package com.bxm.egg.user.integration.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.message.facade.param.CheckSmsCodeParam;
import com.bxm.egg.message.facade.param.SmsTemplateSendParam;
import com.bxm.egg.message.facade.service.SmsFacadeService;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;

/**
 * 短信验证码服务兜底回退
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 9:35 上午
 */
@Slf4j
public class SmsFacadeServiceMock implements SmsFacadeService {

    @Override
    public boolean verify(CheckSmsCodeParam checkSmsCodeParam) {
        log.error("校验验证码服务不可用，类型：{}， 手机号码：{}, 验证码：{}",
                checkSmsCodeParam.getType(), checkSmsCodeParam.getPhoneNum(), checkSmsCodeParam.getCode());
        return true;
    }

    @Override
    public Message send(SmsTemplateSendParam smsTemplateSendParam) {
        log.error("发送短信失败，入参：{}", JSON.toJSONString(smsTemplateSendParam));

        return Message.build(false, "访问人数太多，请稍候~");
    }
}