package com.bxm.egg.user.integration.sync;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.JSONArray;
import com.bxm.sync.facade.dto.InviteFoodsDTO;
import com.bxm.sync.facade.dto.UserTodayContributionDTO;
import com.bxm.sync.facade.param.InviteFoodsParam;
import com.bxm.sync.facade.service.SixEnjoyInviteFoodsFacadeService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/9 6:29 下午
 */
@Slf4j
@Service
public class SixEnjoyInviteFoodsIntegrationService {

    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.sync.SixEnjoyInviteFoodsServiceMock",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private SixEnjoyInviteFoodsFacadeService sixEnjoyInviteFoodsService;

    public Integer getReceiveFoods(Long userId) {
        return sixEnjoyInviteFoodsService.getReceiveFoods(userId);
    }

    public List<InviteFoodsDTO> getTodayContribution(InviteFoodsParam inviteFoodsParam) {
        return sixEnjoyInviteFoodsService.getTodayContribution(inviteFoodsParam);
    }

    public List<UserTodayContributionDTO> getTodayContribution(List<Long> userIdList) {
        if (null == userIdList || userIdList.size() == 0) {
            return Lists.newArrayList();
        }
        return sixEnjoyInviteFoodsService.getTodayContribution(userIdList);
    }

    public List<UserTodayContributionDTO> getTodayContribution(Long userId) {
        return sixEnjoyInviteFoodsService.getTodayContribution(userId);
    }
}