package com.bxm.egg.user.param;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 调用六享的接口绑定微信
 *
 * @author liujia
 * @date 10/21/21 5:51 PM
 **/
@Data
@Builder
public class EggSixEnjoyBindParam {
    @Tolerate
    public EggSixEnjoyBindParam() {
    }

    /**
     * 用户ID
     */
    private Long user_id;

    /**
     * 微信openid
     */
    private String openid;

    /**
     * 微信unionId
     */
    private String unionId;

    /**
     * 微信access_token，张涛需要，不知道有啥用
     */
    private String access_token;

    /**
     * 微信昵称
     */
    private String nickName;

    /**
     * 微信头像
     */
    private String avatarUrl;

    /**
     * 城市
     */
    private String city;

    /**
     * 性别
     */
    private String gender;
}
