package com.bxm.egg.user.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(description = "帖子基础详情")
public class ForumBasicVo {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("发帖地址")
    private String location;

    @ApiModelProperty("帖子文本")
    private String textField;

    @ApiModelProperty("版块id")
    private Long forumId;

    @ApiModelProperty("话题id列表")
    private List<Long> topicIdList;

    @ApiModelProperty("是否新人一键发布 0不是,1是")
    private Byte isNewReport;

    @ApiModelProperty("版块内容")
    private String forumContent;

    @ApiModelProperty("封面选择")
    private Byte coverSelect;

    @ApiModelProperty("额外内容，拼接在textField后，imgList前")
    private String extraContent;

    @ApiModelProperty("帖子类型(1:普通帖子 2:小纸条)")
    private Byte postType;

    @ApiModelProperty("有效期(单位:天)")
    private Integer validDay;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getTextField() {
        return textField;
    }

    public void setTextField(String textField) {
        this.textField = textField;
    }

    public Long getForumId() {
        return forumId;
    }

    public void setForumId(Long forumId) {
        this.forumId = forumId;
    }

    public List<Long> getTopicIdList() {
        return topicIdList;
    }

    public void setTopicIdList(List<Long> topicIdList) {
        this.topicIdList = topicIdList;
    }

    public Byte getIsNewReport() {
        return isNewReport;
    }

    public void setIsNewReport(Byte isNewReport) {
        this.isNewReport = isNewReport;
    }

    public String getForumContent() {
        return forumContent;
    }

    public void setForumContent(String forumContent) {
        this.forumContent = forumContent;
    }

    public Byte getCoverSelect() {
        return coverSelect;
    }

    public void setCoverSelect(Byte coverSelect) {
        this.coverSelect = coverSelect;
    }

    public String getExtraContent() {
        return extraContent;
    }

    public void setExtraContent(String extraContent) {
        this.extraContent = extraContent;
    }

    public Byte getPostType() {
        return postType;
    }

    public void setPostType(Byte postType) {
        this.postType = postType;
    }

    public Integer getValidDay() {
        return validDay;
    }

    public void setValidDay(Integer validDay) {
        this.validDay = validDay;
    }
}
