/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.integration;

import com.bxm.egg.user.constant.DomainScene;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.foundation.base.facade.enums.DomainScene;
import com.bxm.foundation.base.facade.enums.DomainViewScene;
import com.bxm.foundation.base.facade.param.DomainFetchParam;
import com.bxm.foundation.base.facade.service.DomainFacadeService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class DomainIntegrationService {
    @DubboReference(protocol="dubbo", mock="com.bxm.egg.user.integration.fallback.DomainFacadeServiceMock", cluster="failover", version="1.0.0", check=false, lazy=true)
    private DomainFacadeService domainFacadeService;
    @Resource
    private UserProperties userProperties;

    public String getBaseUrlInfoByScene(com.bxm.egg.user.constant.DomainScene scene, DomainScene.DomainViewScene viewScene, String appId) {
        DomainFetchParam param = new DomainFetchParam();
        param.setAppId(appId);
        param.setScene(DomainScene.forScene((Byte)scene.getScene()));
        param.setViewScene(DomainViewScene.forViewScene((Byte)viewScene.getScene()));
        return this.domainFacadeService.getBaseUrlInfo(param);
    }

    public String getInnerH5BaseUrl() {
        return this.domainFacadeService.getInnerH5BaseUrl(this.userProperties.getSrcApp());
    }

    public String getOutSideShareBaseUrl(DomainScene.DomainViewScene viewScene) {
        String baseUrlInfoByScene = this.getBaseUrlInfoByScene(com.bxm.egg.user.constant.DomainScene.OUTSIDE_SHARE, viewScene, null);
        return StringUtils.isNotBlank((CharSequence)baseUrlInfoByScene) ? baseUrlInfoByScene : "";
    }
}

