package com.bxm.egg.user.model.dto.info;

import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.WearMedalDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/12 3:38 下午
 */
@Data
@ApiModel("用户完整信息")
public class UserDetailInfoDTO extends UserBriefInfoDTO {
    @ApiModelProperty("用户性别：0:未知; 1:男; 2:女")
    private Byte sex;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty("3.12.0 用户温暖值等级信息")
    private UserEquityDTO userWarmLevelDTO;

    @ApiModelProperty(value = "3.12.0 佩戴勋章列表")
    private List<WearMedalDTO> wearMedalList;
}