package com.bxm.egg.user.model.dto.warmlevel;

import com.bxm.egg.user.model.UserEquityDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lowi
 * @date 2021/2/26 14:07
 */
@ApiModel("用户温暖值等级信息详情")
@Data
public class UserWarmLevelInfoDTO {

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("温暖值")
    private Integer warmValue;

    @ApiModelProperty("头像")
    private String headImg;

    @ApiModelProperty("等级")
    private Integer level;

    @ApiModelProperty("等级图片")
    private String levelUrl;

    @ApiModelProperty("是否显示查看提示")
    private Boolean showTips;

    @ApiModelProperty(value = "用户权益等级类", hidden = true)
    private UserEquityDTO equityDTO;
}
