package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户账户信息表
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_account")
@ApiModel(value = "UserAccountEntity对象", description = "用户账户信息表")
public class UserAccountEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "用户ID")
    private Long userId;

    @ApiModelProperty(value = "余额【六享】")
    private BigDecimal money;

    @ApiModelProperty(value = "蛋币【六享】")
    private BigDecimal eggCoin;

    @ApiModelProperty(value = "联营人余额【六享】")
    private BigDecimal companyMoney;

    @ApiModelProperty(value = "积分【六享】")
    private Integer score;

    @ApiModelProperty(value = "总共得到多少粮食【六享】")
    private Integer allFoods;

    @ApiModelProperty(value = "粮食余量【六享】")
    private Integer usableFoods;

    @ApiModelProperty(value = "总计消耗粮食100【六享】")
    private Integer usedFoods;

    @ApiModelProperty(value = "总计获得蛋数【六享】")
    private Integer allEgg;

    @ApiModelProperty(value = "蛋余量【六享】")
    private Integer usableEgg;

    @ApiModelProperty(value = "消耗鸡蛋【六享】")
    private Integer usedEgg;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "变更时间")
    private LocalDateTime modifyTime;


}
