package com.bxm.egg.user.model.entity;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.util.Date;

/**
 * @author
 */
@Data
@Builder
public class UserBlock implements Serializable {

    @Tolerate
    public UserBlock() {
    }

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 限制类型-0:禁止私聊,1-拉黑,2-推荐降权,逗号隔开入"0,1,2"
     */
    private Integer blockType;

    /**
     * 限制时间
     */
    private Date blockTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    private static final long serialVersionUID = 1L;


}