package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户定位表
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_location")
@ApiModel(value = "UserLocationEntity对象", description = "用户定位表")
public class UserLocationEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "user_id")
    private Long userId;

    @ApiModelProperty(value = "家乡区域编码")
    private String hometownCode;

    @ApiModelProperty(value = "家乡区域名称")
    private String hometownName;

    @ApiModelProperty(value = "定位区域编码")
    private String locationCode;

    @ApiModelProperty(value = "定位区域名称")
    private String locationName;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


}
