package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户登录历史表
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_login_history")
@ApiModel(value = "UserLoginHistoryEntity对象", description = "用户登录历史表")
public class UserLoginHistoryEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "用户ID")
    private Long userId;

    @ApiModelProperty(value = "登录方式")
    private String loginType;

    @ApiModelProperty(value = "登录IP")
    private String loginIp;

    @ApiModelProperty(value = "登录使用的设备ID")
    private Long equipmentId;

    @ApiModelProperty(value = "是否首次登录")
    private Integer firstLogin;

    @ApiModelProperty(value = "登录时间")
    private LocalDateTime loginTime;

    @ApiModelProperty(value = "登录平台")
    private Integer platform;

    @ApiModelProperty(value = "登录的客户端渠道")
    private String clientChannel;


}
