package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户注册日志表
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_register_log")
@ApiModel(value = "UserRegisterLogEntity对象", description = "用户注册日志表")
public class UserRegisterLogEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "用户ID")
    private Long userId;

    @ApiModelProperty(value = "邀请人")
    private Integer inviteUserId;

    @ApiModelProperty(value = "注册来源")
    private String registerSource;

    @ApiModelProperty(value = "注册IP")
    private String loginIp;

    @ApiModelProperty(value = "注册平台")
    private Integer platform;

    @ApiModelProperty(value = "注册渠道")
    private String channel;

    @ApiModelProperty(value = "登录时间")
    private LocalDateTime registerTime;


}
