package com.bxm.egg.user.model.param;

import com.bxm.egg.user.model.param.login.WechatAppLoginParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

@ApiModel(description = "微信绑定手机号登录参数")
@Data
@EqualsAndHashCode(callSuper = true)
public class WechatBindMobileOneKeyLoginParam extends WechatAppLoginParam {

    private static final long serialVersionUID = -1594917108240353593L;

    @ApiModelProperty(value = "一键登录token", required = true)
    @NotBlank(message = "一键登录token不能为空")
    private String token;

    @ApiModelProperty(value = "用户id", hidden = true)
    private Long userId;

    @ApiModelProperty(value = "手机号码", hidden = true)
    private String phone;
}
