package com.bxm.egg.user.model.param.earnings;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lowi
 * @date 2020/12/16 13:54
 */
@ApiModel("收益保存或更新类")
@Data
public class EarningsSaveOrUpdateParam {
    /**
     * 隐藏的参数可以不用传，
     */
    @ApiModelProperty(value = "(收益人的id)用户id", hidden = true)
    private Long userId;
    @ApiModelProperty(value = "状态   1 待核销 2 已结算 3 待升级 4 已失效", hidden = true)
    private Integer status;
    @ApiModelProperty(value = "是否是团队收益 0 不是 1是", hidden = true)
    private Integer isTeamEarnings;
    @ApiModelProperty(value = "收益类型不同，代表不同类型的id", hidden = true)
    private Long relationId;
    @ApiModelProperty(value = "插入标识，用于处理平台奖励、vip开卡之类的数据，直接插入收益", hidden = true)
    private Boolean insertFlag;
    @ApiModelProperty(value = "佣金", hidden = true)
    private BigDecimal commission;
    /**
     * {@link com.bxm.egg.user.enums.UserEarningsTypeEnum}
     */
    @ApiModelProperty("收益类型")
    private Integer earningsType;
    @ApiModelProperty("收益标题")
    private String earningsTitle;
    @ApiModelProperty("收益的图片")
    private String img;
    @ApiModelProperty("订单号")
    private String orderNo;
    @ApiModelProperty("订单时间")
    private Date orderTime;
    @ApiModelProperty("（创造收益的用户id）购买的用户id")
    private Long createProfitUserId;
    @ApiModelProperty("（站外下订单使用）购买用户的名称")
    private String sellUserName;
    @ApiModelProperty("（站外下订单使用）购买用户的手机号")
    private String sellUserPhone;

    @ApiModelProperty("站内商户订单的商品ID")
    private Long goodsId;
}
