package com.bxm.egg.user.model.param.login;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

@ApiModel(description = "微信绑定手机号登录参数")
@Data
@EqualsAndHashCode(callSuper = true)
public class WechatBindMobileLoginParam extends WechatAppLoginParam {

    private static final long serialVersionUID = -1594917108240353593L;
    @ApiModelProperty(value = "登录手机号码", required = true)
    @NotBlank(message = "手机号码不能为空")
    private String phone;

    @ApiModelProperty(value = "登录验证码", required = true)
    @NotBlank(message = "验证码不能为空")
    private String smsCode;

    @ApiModelProperty(value = "用户id", hidden = true)
    private Long userId;
}
