package com.bxm.egg.user.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "普通h5站外注册传参实体")
public class H5RegisterParam{

    @ApiModelProperty("用户ID，同时也是用户的邀请码。如果是注册绑定则传递静默注册用户ID 有则必传")
    private Long id;

    @ApiModelProperty("登录标识-手机号 必传")
    private String loginName;

    @ApiModelProperty("登录类型,1:手机号、密码登录 必传")
    private Byte type;

    @ApiModelProperty("用户手机号码 必传")
    private String phone;

    @ApiModelProperty("手机验证码 必传")
    private String code;

    @ApiModelProperty("登录密码 必传")
    private String password;

    @ApiModelProperty("邀请码 非必要")
    private Long inviteCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getInviteCode() {
        return inviteCode;
    }

    public void setInviteCode(Long inviteCode) {
        this.inviteCode = inviteCode;
    }
}
