package com.bxm.egg.user.model.vo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "用户邀请记录")
public class InviteRecord extends BaseBean {

    private static final long serialVersionUID = -4847138222108212772L;
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("发起邀请人id")
    private Long userId;

    @ApiModelProperty("被邀请人id")
    private Long invitedUserId;

    @ApiModelProperty("唯一编码")
    private String uniqueCode;

    @ApiModelProperty("被邀请人名称")
    private String invitedUserName;

    @ApiModelProperty("被邀请人头像")
    private String invitedUserImg;

    @ApiModelProperty("邀请途径：NEWS、ACTIVITY、MERCHANT、APPLET、VIP")
    private String type;

    @ApiModelProperty("奖励数量")
    private BigDecimal award = BigDecimal.ZERO;

    @ApiModelProperty("奖励类型")
    private String awardType;

    @ApiModelProperty("邀请进度或状态: ACCEPT_INVITE、LOGIN_APP、SUCCESS_WITHDRAW、OVERDUE_INVALID、NOT_NEW_USER")
    private String inviteState;

    @ApiModelProperty("失效时间")
    private Date effectTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("变更时间")
    private Date modifyTime;

    @ApiModelProperty("邀请状态")
    private Byte status;
}
