package com.bxm.egg.user.model.vo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * a_user_earnings
 *
 * @author lowi
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户收益流水信息表")
@Data
public class UserEarnings extends BaseBean {
    private static final long serialVersionUID = 2692223011732153998L;
    private Long id;

    /**
     * (受益人的id)用户id
     */
    private Long userId;

    /**
     * 收益类型的总类型--总类型ps淘宝返佣
     */
    private Integer type;

    /**
     * 收益类型--细分类型ps淘宝自购，淘宝返佣，淘宝团队
     */
    private Integer earningsType;

    /**
     * 收益标题
     */
    private String earningsTitle;

    /**
     * 收益类型不同，代表不同类型的id
     */
    private Long relationId;

    /**
     * 收益类型的图片
     */
    private String img;

    private String orderNo;

    private Date orderTime;

    /**
     * 佣金
     */
    private BigDecimal commission;

    /**
     * 状态   1 待核销 2 已结算 3 待升级 4 已失效
     */
    private Integer status;

    /**
     * 是否是团队收益 0 不是 1是
     */
    private Integer isTeamEarnings;

    /**
     * （创造收益的用户id) 购买的用户id
     */
    private Long createProfitUserId;

    /**
     * （站外下订单使用）购买用户的名称
     */
    private String sellUserName;

    /**
     * （站外下订单使用）购买用户的手机号
     */
    private String sellUserPhone;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 商品ID
     */
    private Long goodsId;

}