package com.bxm.egg.user.model.vo;

import java.io.Serializable;
import java.util.Date;

/**
 * a_user_login_history
 * @author 
 */
public class UserLoginHistory implements Serializable {

    private Long id;

    private Long userId;

    /**
     * 最后登录时间
     */
    private Date lastLoginTime;

    /**
     * 最后登录ip
     */
    private String lastLoginIp;

    /**
     * 设备号
     */
    private String equipment;

    private Date createTime;

    private Date updateTime;

    /**
     * 手机型号
     */
    private String phoneModel;

    /**
     * 操作系统
     */
    private String operatingSystem;

    /**
     * 客户端版本
     */
    private String clientVersion;

    /**
     * 服务端版本
     */
    private String serverVersion;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Date getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getLastLoginIp() {
        return lastLoginIp;
    }

    public void setLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getEquipment() {
        return equipment;
    }

    public UserLoginHistory setEquipment(String equipment) {
        this.equipment = equipment;
        return this;
    }

    public String getPhoneModel() {
        return phoneModel;
    }

    public UserLoginHistory setPhoneModel(String phoneModel) {
        this.phoneModel = phoneModel;
        return this;
    }

    public String getOperatingSystem() {
        return operatingSystem;
    }

    public UserLoginHistory setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    public String getClientVersion() {
        return clientVersion;
    }

    public UserLoginHistory setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        return this;
    }

    public String getServerVersion() {
        return serverVersion;
    }

    public UserLoginHistory setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public static UserLoginHistory buildUserLoginHistory(Long id, Long userId, String lastLoginIp, String equipment) {
        Date date = new Date();
        UserLoginHistory userLoginHistory = new UserLoginHistory();
        userLoginHistory.setId(id);
        userLoginHistory.setLastLoginIp(lastLoginIp);
        userLoginHistory.setUserId(userId);
        userLoginHistory.setEquipment(equipment);
        userLoginHistory.setLastLoginTime(date);
        userLoginHistory.setCreateTime(date);
        userLoginHistory.setUpdateTime(date);
        return userLoginHistory;
    }
}