package com.bxm.egg.user.model.vo.medal;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/2/24 3:42 下午
 */
@Data
@ApiModel("定制勋章详情VO")
public class CustomMedalDetailVO {

    @ApiModelProperty("勋章id")
    private Long medalId;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("勋章名称")
    private String medalName;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("头像url")
    private String headImg;

    @ApiModelProperty("用户等级")
    private Integer userLevel;

    @ApiModelProperty("用户等级图标")
    private String userLevelImg;

    @ApiModelProperty("当前勋章等级的说明")
    private String medalExplain;

    @ApiModelProperty("展示图标地址")
    private String displayIconUrl;

    @ApiModelProperty("授予时间")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    private Date grantDateTime;
}