package com.bxm.egg.user.model.vo.medal;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 单个勋章VO基类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/2/24 11:37 上午
 */
@Data
@ApiModel("单个勋章信息VO基类")
public class SingleCustomMedalBaseVO {
    @ApiModelProperty("勋章id")
    private Long medalId;

    @ApiModelProperty("勋章图片的地址")
    private String medalImgUrl;

    @ApiModelProperty("勋章的名称")
    private String medalName;

    @ApiModelProperty("是否过期")
    private Boolean expired;

    @ApiModelProperty("过期时间 已格式化")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    private Date expiredTime;

    @ApiModelProperty(value = "状态", hidden = true)
    private Integer expiredStatus;
}