package com.bxm.egg.user.model.dto;

import java.math.BigDecimal;
import java.util.List;

import com.google.common.collect.Lists;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/4 23:09
 * @desc
 */
@ApiModel(description = "赏金相关信息")
public class BountyDTO {

    @ApiModelProperty("已作废赏金")
    List<InviteRecordDTO> discardCashList = Lists.newArrayList();

    @ApiModelProperty("在路上赏金列表")
    List<InviteRecordDTO> availableCashList = Lists.newArrayList();

    @ApiModelProperty("在路上总赏金")
    private BigDecimal availableCash = BigDecimal.ZERO;

    @ApiModelProperty("已作废总赏金")
    private BigDecimal discardCash = BigDecimal.ZERO;

    public List<InviteRecordDTO> getDiscardCashList() {
        return discardCashList;
    }

    public void setDiscardCashList(List<InviteRecordDTO> discardCashList) {
        this.discardCashList = discardCashList;
    }

    public List<InviteRecordDTO> getAvailableCashList() {
        return availableCashList;
    }

    public void setAvailableCashList(List<InviteRecordDTO> availableCashList) {
        this.availableCashList = availableCashList;
    }

    public BigDecimal getAvailableCash() {
        return availableCash;
    }

    public void setAvailableCash(BigDecimal availableCash) {
        this.availableCash = availableCash;
    }

    public BigDecimal getDiscardCash() {
        return discardCash;
    }

    public void setDiscardCash(BigDecimal discardCash) {
        this.discardCash = discardCash;
    }
}
