package com.bxm.egg.user.model.dto;

import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.dto.homepage.*;
import com.bxm.egg.user.model.dto.medal.UserMedalDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(description = "用户基本信息（蛋蛋佳WST-version）")
@Data
public class UserBaseInfoDTO {

    @ApiModelProperty(value = "头像链接")
    private String headImg;

    @ApiModelProperty(value = "昵称")
    private String nickname;

    @ApiModelProperty("用户性别：0:未知; 1:男; 2:女")
    private Integer sex;

    @ApiModelProperty(value = "我的发布数量")
    private Integer forumNum;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty(value = "关注数量")
    private Integer attentionNum;

    @ApiModelProperty(value = "粉丝数量")
    private Integer fanNum;

    @ApiModelProperty(value = "所有访问数量")
    private Integer allInterviewNum;

    @ApiModelProperty(value = "今日访问数量")
    private Integer todayInterviewNum;

    @ApiModelProperty(value = "粉丝数量右上角未读小红点")
    private Integer unReadFanNum;

    @ApiModelProperty("邀请的徒弟的头像地址列表，用于在个人中心显示")
    private List<String> inviteUserHeadImgList;

    @ApiModelProperty("用户勋章相关信息")
    private UserMedalDTO userMedalDTO;

    @ApiModelProperty("3.12.0用户权益等级信息")
    private UserEquityDTO equityDTO;

    @ApiModelProperty("【蛋蛋佳1.2.0】用户角色信息")
    private EggUserRoleDTO eggUserRoleDTO;

    @ApiModelProperty("【蛋蛋佳1.2.0】账户统计信息")
    private EggAccountDTO eggAccountDTO;

    @ApiModelProperty("【蛋蛋佳1.2.0】用户钱包信息")
    private EggPacketSimpleDTO eggPacketSimpleDTO;

    @ApiModelProperty("【蛋蛋佳1.2.0】邀请信息")
    private EggInviteDTO eggInviteDTO;

    @ApiModelProperty("【蛋蛋佳1.2.0】我的代理信息")
    private EggAgentInfoDTO eggAgentInfoDTO;

    @ApiModelProperty("【蛋蛋佳1.2.0】我的联营")
    private EggAgentBusinessDTO eggAgentBusinessDTO;
}
