package com.bxm.egg.user.model.dto.manage.info;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 用户管理列表DTO
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/27 9:37 上午
 */
@Data
@ApiModel("用户管理列表DTO")
public class UserManageListDTO {
    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("头像")
    private String headImg;

    @ApiModelProperty("地区名称")
    private String areaName;

    @ApiModelProperty("温暖值等级")
    private Integer warmLevel;

    @ApiModelProperty("勋章个数")
    private Integer medalNum;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("用户类型：1：普通用户，2：测试用户，3：马甲号")
    private Integer type;

    @ApiModelProperty("注册时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date registerTime;
}