package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import static org.apache.commons.lang.StringUtils.isBlank;

/**
 * <p>
 * 用户资料表
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_information")
@ApiModel(value = "UserInformationEntity对象", description = "用户资料表")
public class UserInformationEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "user_id")
    private Long userId;

    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ApiModelProperty(value = "生日日期")
    private Date birthday;

    @ApiModelProperty(value = "用户个人信息地址")
    private String address;

    @ApiModelProperty(value = "背景图")
    private String backgroundImgUrl;

    @ApiModelProperty(value = "情感状态")
    private Byte relationshipStatus;

    @ApiModelProperty(value = "职业名称")
    private String jobTitle;

    @ApiModelProperty(value = "公司名称")
    private String company;

    @ApiModelProperty(value = "行业类型")
    private Integer jobType;

    @ApiModelProperty(value = "行业类型名称")
    private String jobTypeName;

    @ApiModelProperty(value = "行业种类")
    private Integer jobCategory;

    @ApiModelProperty(value = "行业种类名称")
    private String jobCategoryName;

    @ApiModelProperty(value = "格言【六享】")
    private String personalProfile;

    @ApiModelProperty(value = "用户资料完善度")
    private Long infoCompleteState;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    /**
     * 是否默认的个人简介
     *
     * @return 是否有默认个人简介
     */
    public boolean getIsDefaultPersonalProfile() {
        return isBlank(this.personalProfile);
    }

}
