package com.bxm.egg.user.model.entity.medal;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * t_user_medal_info
 *
 * @author
 */
@Data
public class UserMedalInfoEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 勋章的父id
     */
    private Long parentId;

    /**
     * 勋章名称
     */
    private String name;

    /**
     * 勋章分类：0：成就勋章，1：定制勋章
     */
    private Integer category;

    /**
     * 勋章的类型：如签到、发帖、评论、点赞等
     */
    private String type;

    /**
     * 勋章的等级
     */
    private Integer level;

    /**
     * 勋章展示的顺序
     */
    private Integer tOrder;

    /**
     * 已发人数（定制勋章有效）
     */
    private Long grantCount;

    /**
     * 成就勋章获取规则扩展数据
     */
    private String ruleExtData;

    /**
     * 解锁描述:如连续签到30天即可解锁
     */
    private String unLockDesc;

    /**
     * 升级描述:如连续签到500天可升级
     */
    private String upLevelDesc;

    /**
     * 解锁/升级的跳转地址
     */
    private String jumpUrl;

    /**
     * 已解锁勋章图标地址
     */
    private String activeImgUrl;

    /**
     * 未解锁勋章图标地址
     */
    private String lockImgUrl;

    /**
     * 动图勋章图标地址
     */
    private String gifImgUrl;

    /**
     * 失效勋章图标地址
     */
    private String expiredImgUrl;

    /**
     * 缩略图勋章图标地址
     */
    private String thumbnailUrl;

    /**
     * 勋章成就描述：如xx达成连续签到30天！有这份持久力的，都不是一般人
     */
    private String explainText;

    /**
     * 勋章过期时间，为空则永不过期
     */
    private Date expiredTime;

    /**
     * 勋章状态：0：过期，1：生效（目前只针对定制勋章）
     */
    private Byte status;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    /**
     * 创建人（运营ID）
     */
    private Long creator;

    private static final long serialVersionUID = 1L;
}