package com.bxm.egg.user.model.param;

import com.bxm.newidea.component.param.BasicParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/18 3:03 下午
 */
@Data
public class UserBindWxParam extends BasicParam {

    private static final long serialVersionUID = -7301898597084535256L;
    @ApiModelProperty(value = "微信的openId", required = true)
    @NotBlank(message = "openId不能为空")
    private String openId;

    @ApiModelProperty(value = "微信的unionId", required = true)
    @NotBlank(message = "unionId不能为空")
    private String unionId;

    @ApiModelProperty(value = "微信昵称", required = true)
    @NotBlank(message = "微信昵称不能为空")
    private String nickName;

    @ApiModelProperty(value = "微信头像地址")
    @NotBlank(message = "微信头像地址不能为空")
    private String headImageUrl;

    @ApiModelProperty(value = "获取的性别信息，1：男性，2：女性")
    private Integer sex;

    @ApiModelProperty(value = "国家，如中国为 CN")
    private String country;

    @ApiModelProperty(value = "普通用户个人资料填写的城市")
    private String city;

    @ApiModelProperty(value = "普通用户个人资料填写的省份")
    private String province;

    @ApiModelProperty(value = "微信accessToken")
    private String accessToken;

    @ApiModelProperty(value = "绑定用户的id", required = true)
    @NotNull(message = "绑定的用户id不能为空")
    private Long userId;

}