package com.bxm.egg.user.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "登录请求参数")
@Data
public class LoginInfo extends User {

    @ApiModelProperty("登录标识,如果是手机号密码则传递手机号码，如果是第三方登录则传递第三方登录标识")
    private String loginName;

    @ApiModelProperty("手机验证码")
    private String code;

    @ApiModelProperty("登录类型,1:手机号、密码登录，2：QQ登录，3：微信登录，4：微博登录")
    private Byte type;

    @ApiModelProperty("邀请码")
    private Long inviteCode;

    @ApiModelProperty("注册地址")
    private String registeredaddress;

    @ApiModelProperty("登录密码")
    private String password;

    @ApiModelProperty("如果当前登录请求属于忘记密码并登录则设置为true")
    private Boolean resetPwd;

    @ApiModelProperty("微信的openId [H5]")
    private String openId;

    @ApiModelProperty("微信的unionId [H5]")
    private String unionId;

    @ApiModelProperty("风险评估设备token")
    private String deviceToken;

    @ApiModelProperty("手机型号")
    private String phonemodel;

    @ApiModelProperty("操作系统版本号")
    private String operatingSystem;
}
