package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 微信APP授权登录记录
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_grant_wechat_app")
@ApiModel(value = "UserGrantWechatAppEntity对象", description = "微信APP授权登录记录")
public class UserGrantWechatAppEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "用户ID")
    private Long userId;

    @ApiModelProperty(value = "微信APP对应的openid")
    private String openId;

    @ApiModelProperty(value = "开放平台下的唯一ID")
    private String unionId;

    @ApiModelProperty(value = "微信授权时的昵称")
    private String nickName;

    @ApiModelProperty(value = "微信授权的头像")
    private String headImg;

    @ApiModelProperty(value = "微信授权时的性别信息，1：男，2：女，3：未知")
    private Integer sex;

    @ApiModelProperty(value = "省份信息")
    private String province;

    @ApiModelProperty(value = "国家信息")
    private String country;

    @ApiModelProperty(value = "城市信息")
    private String city;

    @ApiModelProperty(value = "1删除，0未删除")
    private Integer deleted;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "变更时间")
    private Date modifyTime;
}
