package com.bxm.egg.user.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@ApiModel("用户标签传参实体")
public class UserTagParam {

    @ApiModelProperty("用户ID")
    @NotNull
    private Long userId;

    @ApiModelProperty("兴趣爱好标签列表")
    private List<SpecificUserTagParam> specificUserTagParamList;

    public static class SpecificUserTagParam {
        @ApiModelProperty("兴趣爱好标签名称")
        private String label;

        @ApiModelProperty("兴趣爱好标签id")
        private String id;

        @ApiModelProperty("是否是默认标签 0：不是  1：是")
        private Byte defaultFlag;

        @ApiModelProperty("是否选中")
        private Byte chooseFlag;

        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Byte getDefaultFlag() {
            return defaultFlag;
        }

        public void setDefaultFlag(Byte defaultFlag) {
            this.defaultFlag = defaultFlag;
        }

        public Byte getChooseFlag() {
            return chooseFlag;
        }

        public void setChooseFlag(Byte chooseFlag) {
            this.chooseFlag = chooseFlag;
        }
    }

}
