package com.bxm.egg.user.model.param.login;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/10 4:15 下午
 */
@Data
@ApiModel("用户设置密码入参")
public class UserSettingsPasswordParam extends LoginParam {

    private static final long serialVersionUID = 1069890677262542249L;
    @ApiModelProperty(value = "用户id")
    @NotNull(message = "用户id")
    private Long userId;

    @ApiModelProperty("手机号码")
    @NotBlank(message = "手机号码不能为空")
    private String phone;

    @ApiModelProperty("短信验证码")
    @NotBlank(message = "验证码不能为空")
    private String smsCode;

    @ApiModelProperty("用户设置的密码")
    @NotBlank(message = "密码不能为空")
    private String password;
}