package com.bxm.egg.user.model.param.login;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 微信APP登录信息
 *
 * @author wzy
 * @date 2021年09月09日11:51:02
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "微信APP登录信息")
public class WechatAppLoginParam extends LoginParam {

    private static final long serialVersionUID = -7301898597084535256L;
    @ApiModelProperty(value = "微信的openId", required = true)
    @NotBlank(message = "openId不能为空")
    private String openId;

    @ApiModelProperty(value = "微信的unionId", required = true)
    @NotBlank(message = "unionId不能为空")
    private String unionId;

    @ApiModelProperty(value = "微信昵称", required = true)
    @NotBlank(message = "微信昵称不能为空")
    private String nickName;

    @ApiModelProperty(value = "微信头像地址")
    @NotBlank(message = "微信头像地址不能为空")
    private String headImageUrl;

    @ApiModelProperty(value = "获取的性别信息，1：男性，2：女性")
    private Integer sex;

    @ApiModelProperty(value = "国家，如中国为 CN")
    private String country;

    @ApiModelProperty(value = "普通用户个人资料填写的城市")
    private String city;

    @ApiModelProperty(value = "普通用户个人资料填写的省份")
    private String province;

    @ApiModelProperty(value = "微信accessToken")
    private String accessToken;
}
