package com.bxm.egg.user.model.vo.medal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/2/24 12:18 下午
 */
@Data
@ApiModel("单个勋章详细信息VO")
public class SingleAchievementMedalBaseVO {

    @ApiModelProperty("勋章的父id")
    private Long medalParentId;

    @ApiModelProperty("勋章id")
    private Long medalId;

    @ApiModelProperty("勋章图片的地址")
    private String medalImgUrl;

    @ApiModelProperty("勋章的名称")
    private String medalName;

    @ApiModelProperty("勋章的等级")
    private Integer level;

    @ApiModelProperty("勋章状态：0待解锁，1已获得可升级，2已获得不可升级")
    private Integer status;

    @ApiModelProperty(value = "勋章展示顺序", hidden = true)
    private Integer tOrder;
}