package com.bxm.egg.user.properties;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;

/**
 * 用户配置类
 *
 * @author wzy
 * @date 2021年10月12日16:00:06
 */
@Component
@ConfigurationProperties("user.config")
@Data
public class UserProperties {

    /**
     * 个人资料页面小红花提示
     */
    private String infoCompleteTaskText = "首次完成资料赠送30朵小红花";

    /**
     * 邀请好友的滚动弹幕列表
     */
    private List<String> inviteScrollList = Lists.newArrayList();

    /*******蛋蛋佳v1.2.0*******/
    /**
     * 用户如果获取不到头像后的默认头像
     */
    private String defaultHeadImageUrl = "http://bxm-news.oss-cn-hangzhou.aliyuncs.com/img/defaultHeadImg.png";

    /**
     * 用户缓存信息的过期时间(单位：秒)
     */
    private Long userCacheExpiredSeconds = 3 * 60 * 60L;


    /**
     * 引导完善资料阈值
     */
    private Integer nativeNewbieGuideThreshold = 80;

    /**
     * 本地人列表引导完善资料卡片文案
     */
    private String nativeNewbieGuideText = "完善个人信息，让更多人认识你";

    /**
     * 本地人列表引导完善资料个人简介
     */
    private String nativeNewbieGuidePersonalProfile = "未填写个人介绍";

    /**
     * 本地人列表引导完善资料卡片位置
     */
    private Integer nativeNewbieGuidePosition = 2;


    /************************Token相关配置******************************/

    /**
     * token密钥，用于校验不同的token的有效性
     * key：应用名称
     * value：应用对应的密钥
     */
    private String appTokenSecret = "emqhJlRkP30PSAuYizk4t9BEPUp2DEmR";

    /**
     * 刷新token的默认过期时间（180天）
     */
    private int refreshTokenExpiredSeconds = 180 * 24 * 60 * 60;

    /**
     * accessToken默认的过期时间（30分钟）
     */
    private int accessTokenExpiredSeconds = 30 * 60;

    /**
     * 是否开启短信验证码
     */
    private Boolean smsVerify = false;

    /**
     * 测试用户的手机号码
     */
    private List<String> testUserPhone = Arrays.asList("17681826219");

    /**
     * 邀请好友头像个数
     */
    private Integer inviteHeadImgNum = 5;

    /**
     * 应用名
     */
    private String srcApp = "egg";

    /**
     * 默认区域编码
     */
    private String defaultLocationCode = "371100000000";

    /**
     * 默认蛋蛋佳迁移用户区域编码
     */
    private String migrationDefaultLocationCode = "371100000000";

    /**
     * 处理勋章消息速度
     */
    private Long handleMedalMsgSpeech = 1000L;

    /**
     * 签到温暖值
     */
    private Integer signWarmValue = 2;

    /**
     * 完成资料温暖值
     */
    private Integer completeUserInfoWarmValue = 20;

    /**
     * 登录温暖值
     */
    private Integer loginWarmValue = 2;

    /**
     * 勋章弹窗数据过期时间
     */
    private Long userMedalPopExpiredSecond = 60L * 60L * 24L * 30L;
}
