/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.account.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.integration.sync.UserEggCouponIntegrationService;
import com.bxm.egg.user.mapper.UserAccountMapper;
import com.bxm.egg.user.model.dto.account.UserBaseAccountInfoDTO;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.egg.user.model.param.account.DecreaseGoodsParam;
import com.bxm.newidea.component.bo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserAccountServiceImpl
implements UserAccountService {
    private static final Logger log = LoggerFactory.getLogger(UserAccountServiceImpl.class);
    private final UserAccountMapper userAccountMapper;
    private final UserEggCouponIntegrationService userEggCouponIntegrationService;

    @Override
    public UserBaseAccountInfoDTO baseInfo(Long userId) {
        UserAccountEntity userAccountEntity = this.getUserAccountInfo(userId);
        return UserBaseAccountInfoDTO.builder().userId(userId).usableEggCouponNum(this.userEggCouponIntegrationService.getUserEggCouponEggNum(userId)).usableEggNum(userAccountEntity.getUsableEgg()).build();
    }

    @Override
    public Message decreaseGoods(DecreaseGoodsParam decreaseGoodsParam) {
        return Message.build((boolean)true);
    }

    @Override
    public UserAccountEntity getUserAccountInfo(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserAccountEntity::getUserId, (Object)userId);
        return (UserAccountEntity)this.userAccountMapper.selectOne((Wrapper)queryWrapper);
    }

    public UserAccountServiceImpl(UserAccountMapper userAccountMapper, UserEggCouponIntegrationService userEggCouponIntegrationService) {
        this.userAccountMapper = userAccountMapper;
        this.userEggCouponIntegrationService = userEggCouponIntegrationService;
    }
}

