/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.attribute.impl;

import com.bxm.egg.user.attribute.UserAttributeService;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.login.UserService;
import com.bxm.egg.user.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserAttributeServiceImpl
implements UserAttributeService {
    private static final Logger log = LoggerFactory.getLogger(UserAttributeServiceImpl.class);
    private final UserMapper userMapper;
    private final UserStatisticsService userStatisticsService;
    private final UserService userService;

    @Override
    public void addUserFollowCount(Long userId, Long targetUserId, boolean isAdd) {
        int addCount = isAdd ? 1 : -1;
        this.userStatisticsService.addAttentionNum(userId, addCount);
        this.userStatisticsService.addFanNum(targetUserId, addCount);
    }

    @Override
    public void addInviteNum(Long userId) {
        this.userMapper.incrementInviteNum(userId);
        this.userService.loadUserToRedis(userId);
    }

    public UserAttributeServiceImpl(UserMapper userMapper, UserStatisticsService userStatisticsService, UserService userService) {
        this.userMapper = userMapper;
        this.userStatisticsService = userStatisticsService;
        this.userService = userService;
    }
}

