/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.attribute.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.common.constant.InfoCombineStateEnum;
import com.bxm.egg.common.enums.UserStatusEnum;
import com.bxm.egg.user.attribute.UserPersonalInfoService;
import com.bxm.egg.user.attribute.UserTagService;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.integration.BaseIntegrationService;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.login.UserService;
import com.bxm.egg.user.mapper.UserInfoMapper;
import com.bxm.egg.user.mapper.UserInformationMapper;
import com.bxm.egg.user.mapper.UserTagMapper;
import com.bxm.egg.user.model.PopCache;
import com.bxm.egg.user.model.dto.UserAccountMaterialGuideDTO;
import com.bxm.egg.user.model.dto.UserPersonalInfoDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.param.CustomTagParam;
import com.bxm.egg.user.model.param.UserBirthParam;
import com.bxm.egg.user.model.param.UserEmotionParam;
import com.bxm.egg.user.model.param.UserHeadImgParam;
import com.bxm.egg.user.model.param.UserHomeTownParam;
import com.bxm.egg.user.model.param.UserIntroductionParam;
import com.bxm.egg.user.model.param.UserJobParam;
import com.bxm.egg.user.model.param.UserNicknameParam;
import com.bxm.egg.user.model.param.UserSexParam;
import com.bxm.egg.user.model.param.UserTagParam;
import com.bxm.egg.user.model.param.UserWechatParam;
import com.bxm.egg.user.model.vo.User;
import com.bxm.egg.user.model.vo.UserInfoComplete;
import com.bxm.egg.user.model.vo.UserTag;
import com.bxm.egg.user.model.vo.UserTagRedis;
import com.bxm.egg.user.param.UserSyncParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.support.UserSyncService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.CharUtil;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UserPersonalInfoServiceImpl
implements UserPersonalInfoService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(UserPersonalInfoServiceImpl.class);
    private static final String KEY = "PERFECT_INFORMATION_POP";
    private static final String LAST_MODIFY_TIME = "lastModifyTime";
    private static final Pattern WECHAT_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]{6,20}$");
    private final UserInfoMapper userInfoMapper;
    private final UserService userService;
    private final UserSyncService userSyncService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserTagService userTagService;
    private final UserTagMapper userTagMapper;
    private final UserProperties userProperties;
    private final UserInformationMapper userInformationMapper;
    private final RedisSetAdapter redisSetAdapter;
    private ApplicationContext applicationContext;
    private final BaseIntegrationService baseIntegrationService;
    private final UserInformationService userInformationService;
    private final UserLocationService userLocationService;

    @Override
    public Message saveCustomTag(CustomTagParam customTagParam) {
        if (CharUtil.getWordCount((String)customTagParam.getLabel()) > 10) {
            return Message.build((boolean)false, (String)"\u6807\u7b7e\u8d85\u8fc75\u4e2a\u957f\u5ea6");
        }
        if (this.baseIntegrationService.verifySensitiveWord(customTagParam.getLabel()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u6807\u7b7e\u542b\u6709\u654f\u611f\u8bcd\u8bcd\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        Message m = this.preExecute(customTagParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(customTagParam.getUserId());
        List<UserTag> userTagList = this.userTagService.getUserTagFromRedisDb(customTagParam.getUserId());
        long count = userTagList.stream().filter(e -> 0 == e.getDeleteFlag()).count();
        if (count >= 15L) {
            return Message.build((boolean)false, (String)"\u6807\u7b7e\u4e0d\u80fd\u8d85\u8fc715\u4e2a\u54e6");
        }
        int minOder = 0;
        if (!CollectionUtils.isEmpty(userTagList)) {
            minOder = userTagList.get(0).getOrder();
        } else {
            userTagList = new ArrayList<UserTag>();
        }
        UserTag userTag = UserTag.buildUserTag((Long)customTagParam.getUserId(), (Integer)(minOder - 1), (String)customTagParam.getLabel(), (Long)SequenceHolder.nextLongId());
        this.userTagMapper.insert(userTag);
        userTagList.add(0, userTag);
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(customTagParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        this.afterExecute(userEntity, userInformationEntity, false, true, false, userTagList);
        return Message.build((boolean)true).addParam("tag", (Object)this.userTagService.convertUserTag2UserTagDto(userTag));
    }

    @Override
    public Message doUpdateUserTag(UserTagParam user) {
        log.debug("\u66f4\u65b0\u7528\u6237\u6807\u7b7e\u4fe1\u606f\uff1a[{}]", JSONObject.toJSON((Object)user));
        Message m = this.preExecute(user.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        long count = user.getSpecificUserTagParamList().parallelStream().filter(e -> e.getChooseFlag() != 0).count();
        if (count > 15L) {
            return Message.build((boolean)false, (String)"\u6807\u7b7e\u9009\u62e9\u4e2a\u6570\u9650\u5b9a15\u4e2a");
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        UserInformationEntity userInformation = this.userInformationService.getUserInformationById(user.getUserId());
        ArrayList<UserTag> userTagList = new ArrayList<UserTag>();
        Date date = new Date();
        int index = 0;
        for (UserTagParam.SpecificUserTagParam specificUserTagParam : user.getSpecificUserTagParamList()) {
            if (0 == specificUserTagParam.getChooseFlag() && 1 == specificUserTagParam.getDefaultFlag()) continue;
            UserTag userTag = UserTag.builder().createTime(date).id(SequenceHolder.nextLongId()).label(specificUserTagParam.getLabel()).order(Integer.valueOf(index)).defaultFlag(specificUserTagParam.getDefaultFlag()).userId(user.getUserId()).deleteFlag(Byte.valueOf((byte)0)).build();
            if (0 == specificUserTagParam.getChooseFlag() && 0 == specificUserTagParam.getDefaultFlag()) {
                userTag.setDeleteFlag(Byte.valueOf((byte)1));
                userTag.setDeleteTime(date);
            }
            userTagList.add(userTag);
            ++index;
        }
        this.userTagMapper.deleteByUserId(user.getUserId());
        for (UserTag userTag : userTagList) {
            this.userTagMapper.insert(userTag);
        }
        long infoCompleteStatus = userInformation.getInfoCompleteState();
        infoCompleteStatus = !CollectionUtils.isEmpty((Collection)user.getSpecificUserTagParamList()) ? BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex()) : BitOperatorUtil.clearBit((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex());
        userInformation.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
        this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(user.getUserId(), Long.valueOf(infoCompleteStatus)));
        this.afterExecute(userEntity, userInformation, false, true, false, userTagList);
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateHeadImg(UserHeadImgParam userHeadImgParam) {
        Message m = this.preExecute(userHeadImgParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        userEntity.setHeadImg(userHeadImgParam.getHeadImg());
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userHeadImgParam.getUserId());
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HEAD_IMG_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HEAD_IMG_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(userHeadImgParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        UserInfoEntity updateUserHeadImgEntity = new UserInfoEntity();
        updateUserHeadImgEntity.setId(userHeadImgParam.getUserId());
        updateUserHeadImgEntity.setHeadImg(userHeadImgParam.getHeadImg());
        int count = this.userInfoMapper.updateById((Object)updateUserHeadImgEntity);
        if (count <= 0) {
            return Message.build((boolean)false);
        }
        this.afterExecute(userEntity, userInformationEntity, true, false, false, null);
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateNickname(UserNicknameParam userNicknameParam) {
        Message m = this.preExecute(userNicknameParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        if (this.baseIntegrationService.verifySensitiveWord(userNicknameParam.getNickname()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u6635\u79f0\u5305\u542b\u654f\u611f\u8bcd\u6c47");
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        userEntity.setNickname(EmojiCodeParser.replaceSoftbankEmoji((String)userNicknameParam.getNickname()));
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userNicknameParam.getUserId());
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.NICKNAME_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.NICKNAME_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(userNicknameParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        UserInfoEntity updateUserHeadImgEntity = new UserInfoEntity();
        updateUserHeadImgEntity.setId(userNicknameParam.getUserId());
        updateUserHeadImgEntity.setNickname(userNicknameParam.getNickname());
        int count = this.userInfoMapper.updateById((Object)updateUserHeadImgEntity);
        if (count > 0) {
            this.afterExecute(userEntity, userInformationEntity, true, false, false, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateBirth(UserBirthParam userBirthParam) {
        int count;
        Message m = this.preExecute(userBirthParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userBirthParam.getUserId());
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.BIRTHDAY_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.BIRTHDAY_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(userBirthParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        if ((count = this.userInformationService.updateUserBirthday(userBirthParam.getUserId(), userBirthParam.getBirthday())) > 0) {
            this.afterExecute(userEntity, userInformationEntity, false, false, true, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateHometown(UserHomeTownParam userHomeTownParam) {
        int count;
        Message m = this.preExecute(userHomeTownParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userHomeTownParam.getUserId());
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HOMETOWN_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HOMETOWN_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(userHomeTownParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        if ((count = this.userLocationService.updateUserHometownInfo(userHomeTownParam)) > 0) {
            this.afterExecute(userEntity, userInformationEntity, false, false, true, null);
        }
        return Message.build((boolean)true);
    }

    private Message preExecute(Long userId) {
        UserInfoEntity user = (UserInfoEntity)this.userInfoMapper.selectById((Serializable)userId);
        if (null == user) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (UserStatusEnum.ENABLE.getCode() != user.getState().intValue()) {
            log.error("\u51fa\u73b0\u6682\u672a\u5b9a\u4f4d\u539f\u56e0\u7684\u5f02\u5e38\u6570\u636e\uff0c\u5c06\u5176\u66f4\u65b0\u4e3a\u6b63\u5e38\u72b6\u6001\uff0c\u7528\u6237ID\uff1a{}", (Object)userId);
            return Message.build((boolean)false);
        }
        return Message.build((boolean)true).addParam("user", (Object)user);
    }

    private void afterExecute(UserInfoEntity user, UserInformationEntity userInformationEntity, boolean isRedundancyChange, boolean isTagChange, boolean isPush, List<UserTag> userTagList) {
        if (isTagChange) {
            UserTagRedis userTagRedis = UserTagRedis.buildUserTagRedis((Long)user.getId(), userTagList);
            this.redisHashMapAdapter.put(RedisConfig.USER_TAG, String.valueOf(user.getId()), (Object)JSON.toJSONString((Object)userTagRedis));
        }
    }

    private void afterExecute1(User user, boolean isRedundancyChange, boolean isTagChange, boolean isPush, List<UserTag> userTagList) {
        if (isTagChange) {
            UserTagRedis userTagRedis = UserTagRedis.buildUserTagRedis((Long)user.getId(), userTagList);
            this.redisHashMapAdapter.put(RedisConfig.USER_TAG, String.valueOf(user.getId()), (Object)JSON.toJSONString((Object)userTagRedis));
        }
        this.userService.putUserToRedis(user);
        this.userService.checkCompleteInfo(user);
        ((UserPersonalInfoService)this.applicationContext.getBean(UserPersonalInfoService.class)).asyncProcessing(user, isRedundancyChange, isPush);
    }

    @Override
    @Async
    public void asyncProcessing(User user, boolean changeRedundancy, boolean changeRecommendAttr) {
        if (changeRedundancy) {
            UserSyncParam userSyncParam = new UserSyncParam();
            BeanUtils.copyProperties((Object)user, (Object)userSyncParam);
            this.userSyncService.sync(userSyncParam);
        }
    }

    @Override
    public Message doUpdateEmotion(UserEmotionParam userEmotionParam) {
        int count;
        Message m = this.preExecute(userEmotionParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userEmotionParam.getUserId());
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.RELATION_SHIP_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.RELATION_SHIP_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(userEmotionParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        if ((count = this.updateUserEmotion(userEmotionParam)) > 0) {
            this.afterExecute(userEntity, userInformationEntity, false, false, false, null);
        }
        return Message.build((boolean)true);
    }

    private int updateUserEmotion(UserEmotionParam userEmotionParam) {
        UserInformationEntity updateUserInformationEntity = new UserInformationEntity();
        updateUserInformationEntity.setRelationshipStatus(userEmotionParam.getRelationshipStatus());
        LambdaQueryWrapper updateQueryWrapper = new LambdaQueryWrapper();
        updateQueryWrapper.eq(UserInformationEntity::getUserId, (Object)userEmotionParam.getUserId());
        return this.userInformationMapper.update((Object)updateUserInformationEntity, (Wrapper)updateQueryWrapper);
    }

    @Override
    public Message doUpdateJob(UserJobParam userJobParam) {
        int count;
        log.debug("\u66f4\u65b0\u804c\u4e1a,\u53c2\u6570\u4e3a:[{}]", JSONObject.toJSON((Object)userJobParam));
        Message m = this.preExecute(userJobParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userJobParam.getUserId());
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.JOB_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.JOB_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(userJobParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        if ((count = this.updateJobInfo(userJobParam)) > 0) {
            this.afterExecute(userEntity, userInformationEntity, false, false, true, null);
        }
        return Message.build((boolean)true);
    }

    private int updateJobInfo(UserJobParam userJobParam) {
        UserInformationEntity updateUserInformation = new UserInformationEntity();
        updateUserInformation.setCompany(userJobParam.getCompany());
        updateUserInformation.setJobTitle(userJobParam.getJobTitle());
        updateUserInformation.setJobCategory(userJobParam.getJobCategory());
        updateUserInformation.setJobCategoryName(userJobParam.getJobCategoryName());
        updateUserInformation.setJobType(userJobParam.getJobType());
        updateUserInformation.setJobTypeName(userJobParam.getJobTypeName());
        LambdaQueryWrapper updateQueryWrapper = new LambdaQueryWrapper();
        updateQueryWrapper.eq(UserInformationEntity::getUserId, (Object)userJobParam.getUserId());
        return this.userInformationMapper.update((Object)updateUserInformation, (Wrapper)updateQueryWrapper);
    }

    @Override
    public Message doUpdatePersonalProfile(UserIntroductionParam userIntroductionParam) {
        int count;
        if (this.baseIntegrationService.verifySensitiveWord(userIntroductionParam.getPersonalProfile()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u4e2a\u4eba\u7b80\u4ecb\u542b\u6709\u654f\u611f\u8bcd\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        Message m = this.preExecute(userIntroductionParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userIntroductionParam.getUserId());
        userInformationEntity.setPersonalProfile(userIntroductionParam.getPersonalProfile());
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PERSONAL_PROFILE_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PERSONAL_PROFILE_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(userIntroductionParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        if ((count = this.updatePersonalProfileInfo(userIntroductionParam)) > 0) {
            this.afterExecute(userEntity, userInformationEntity, false, false, false, null);
        }
        return Message.build((boolean)true);
    }

    private int updatePersonalProfileInfo(UserIntroductionParam userIntroductionParam) {
        UserInformationEntity updateUserInformation = new UserInformationEntity();
        updateUserInformation.setPersonalProfile(userIntroductionParam.getPersonalProfile());
        LambdaQueryWrapper updateQueryWrapper = new LambdaQueryWrapper();
        updateQueryWrapper.eq(UserInformationEntity::getUserId, (Object)userIntroductionParam.getUserId());
        return this.userInformationMapper.update((Object)updateUserInformation, (Wrapper)updateQueryWrapper);
    }

    @Override
    public Message doUpdateUserSex(UserSexParam userSexParam) {
        Message m = this.preExecute(userSexParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        if (null == userSexParam.getSex() || 0 == userSexParam.getSex()) {
            return Message.build((boolean)true);
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        userEntity.setSex(Integer.valueOf(userSexParam.getSex().byteValue()));
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userSexParam.getUserId());
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.SEX_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.SEX_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(userSexParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        UserInfoEntity updateUserInfoEntity = new UserInfoEntity();
        updateUserInfoEntity.setId(userSexParam.getUserId());
        updateUserInfoEntity.setSex(Integer.valueOf(userSexParam.getSex().byteValue()));
        int count = this.userInfoMapper.updateById((Object)updateUserInfoEntity);
        if (count > 0) {
            this.afterExecute(userEntity, userInformationEntity, true, false, true, null);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message doUpdateUserWechat(UserWechatParam userWechatParam) {
        Message m = this.preExecute(userWechatParam.getUserId());
        if (!m.isSuccess()) {
            return m;
        }
        Message isValid = this.validWechat(userWechatParam.getWechatId());
        if (!isValid.isSuccess()) {
            return isValid;
        }
        UserInfoEntity userEntity = (UserInfoEntity)m.getParam("user");
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userWechatParam.getUserId());
        userEntity.setWeixin(userWechatParam.getWechatId());
        long infoCompleteStatus = userInformationEntity.getInfoCompleteState();
        if (!BitOperatorUtil.getBitAsBoolean((Long)infoCompleteStatus, (int)InfoCombineStateEnum.WECHAT_COMPLETE.getIndex())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.WECHAT_COMPLETE.getIndex());
            userInformationEntity.setInfoCompleteState(Long.valueOf(infoCompleteStatus));
            this.userInformationMapper.updateUserInfoCompleteStatus(new UserInfoComplete(userWechatParam.getUserId(), Long.valueOf(infoCompleteStatus)));
        }
        UserInfoEntity updateUserInfoEntity = new UserInfoEntity();
        updateUserInfoEntity.setId(userWechatParam.getUserId());
        updateUserInfoEntity.setWeixin(userWechatParam.getWechatId());
        int count = this.userInfoMapper.updateById((Object)updateUserInfoEntity);
        if (count > 0) {
            this.afterExecute(userEntity, userInformationEntity, true, false, true, null);
        }
        return Message.build((boolean)true);
    }

    private Message validWechat(String qqorwx) {
        if (com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)qqorwx) || qqorwx.length() < 6 || qqorwx.length() > 20) {
            return Message.build((boolean)false, (String)"\u8bf7\u8f93\u51656-20\u4e2a\u5b57\u7b26\uff0c\u652f\u6301\u5b57\u6bcd\uff0c\u6570\u5b57\uff0c\u4e0b\u5212\u7ebf\u548c\u51cf\u53f7");
        }
        Matcher m = WECHAT_NAME_PATTERN.matcher(qqorwx);
        boolean isValid = m.matches();
        if (!isValid) {
            return Message.build((boolean)false, (String)"\u8bf7\u4e0d\u8981\u8f93\u5165\u4e2d\u6587\u548c\u5176\u4ed6\u7279\u6b8a\u7b26\u53f7");
        }
        return Message.build((boolean)true);
    }

    @Override
    public UserPersonalInfoDTO getUserPersonalInfo(Long userId) {
        UserInfoEntity userInfoEntity = (UserInfoEntity)this.userInfoMapper.selectById((Serializable)userId);
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userId);
        UserLocationEntity userLocationEntity = this.userLocationService.getUserLocationByUserId(userId);
        if (null == userInfoEntity) {
            return null;
        }
        int infoCompletePercent = InfoCombineStateEnum.getInfoCompletePercent((Long)(userInformationEntity.getInfoCompleteState() == null ? 0L : userInformationEntity.getInfoCompleteState()));
        String infoCompleteTaskText = this.userProperties.getInfoCompleteTaskText();
        List<UserTag> userTagList = this.userTagService.getUserTagFromRedisDb(userId);
        UserPersonalInfoDTO userPersonalInfoDTO = this.convertUserInfo2UserPersonalInfo(userInfoEntity, userInformationEntity, userLocationEntity);
        userPersonalInfoDTO.setInfoCompletePercent(Integer.valueOf(infoCompletePercent));
        userPersonalInfoDTO.setInfoCompleteTaskText(infoCompleteTaskText);
        userPersonalInfoDTO.setUserTagList(userTagList.stream().filter(e -> e.getDeleteFlag() == 0).map(UserTag::getLabel).collect(Collectors.toList()));
        return userPersonalInfoDTO;
    }

    private UserPersonalInfoDTO convertUserInfo2UserPersonalInfo(UserInfoEntity userInfoEntity, UserInformationEntity userInformationEntity, UserLocationEntity userLocationEntity) {
        UserPersonalInfoDTO.IndustryInfo industryInfo = null;
        if (null != userInformationEntity) {
            industryInfo = UserPersonalInfoDTO.IndustryInfo.builder().company(userInformationEntity.getCompany()).jobCategory(userInformationEntity.getJobCategory()).jobCategoryName(userInformationEntity.getJobCategoryName()).jobTitle(userInformationEntity.getJobTitle()).jobType(userInformationEntity.getJobType()).jobTypeName(userInformationEntity.getJobTypeName()).build();
        }
        return UserPersonalInfoDTO.builder().personalProfile(userInformationEntity.getPersonalProfile()).isDefaultPersonalProfile(Boolean.valueOf(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)userInformationEntity.getPersonalProfile()))).birthday(userInformationEntity.getBirthday()).headImg(userInfoEntity.getHeadImg()).industryInfo(industryInfo).industry(this.getIndustryInfo(userInformationEntity)).newbieGuideFlag(Byte.valueOf((byte)1)).isTempNickName(Byte.valueOf((byte)1)).generation(this.getGeneration(userInformationEntity.getBirthday())).nickname(userInfoEntity.getNickname()).phone(userInfoEntity.getPhone()).id(userInfoEntity.getId()).relationshipStatus(userInformationEntity.getRelationshipStatus()).sex(userInfoEntity.getSex()).wechatId(userInfoEntity.getWeixin()).hometownCode(userLocationEntity.getHometownCode()).hometownName(userLocationEntity.getHometownName()).build();
    }

    private String getIndustryInfo(UserInformationEntity userInformationEntity) {
        StringBuilder industryBuilder = new StringBuilder();
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userInformationEntity.getJobTitle()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userInformationEntity.getCompany())) {
            industryBuilder.append(userInformationEntity.getCompany()).append(userInformationEntity.getJobTitle());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userInformationEntity.getJobTitle()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userInformationEntity.getCompany()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userInformationEntity.getJobCategoryName())) {
            industryBuilder.append(userInformationEntity.getJobCategoryName());
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userInformationEntity.getJobTitle()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userInformationEntity.getCompany()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userInformationEntity.getJobCategoryName())) {
            industryBuilder.append(userInformationEntity.getJobTitle());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userInformationEntity.getJobTitle()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userInformationEntity.getCompany())) {
            industryBuilder.append(userInformationEntity.getCompany());
        }
        if (industryBuilder.length() > 0) {
            return industryBuilder.toString();
        }
        return null;
    }

    @Override
    public Long initUserInfoCompleteStatus(UserInfoEntity userInfoEntity, UserInformationEntity userInformationEntity, UserLocationEntity userLocationEntity) {
        List<UserTag> userTagList;
        long infoCompleteStatus = 0L;
        if (null != userInfoEntity.getSex() && 0 != userInfoEntity.getSex()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.SEX_COMPLETE.getIndex());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userInfoEntity.getNickname())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.NICKNAME_COMPLETE.getIndex());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userInfoEntity.getHeadImg())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HEAD_IMG_COMPLETE.getIndex());
        }
        if (null != userInformationEntity.getBirthday()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.BIRTHDAY_COMPLETE.getIndex());
        }
        if (null != userInformationEntity.getRelationshipStatus()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.RELATION_SHIP_COMPLETE.getIndex());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userLocationEntity.getHometownCode())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.HOMETOWN_COMPLETE.getIndex());
        }
        if (null != userInformationEntity.getJobCategory()) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.JOB_COMPLETE.getIndex());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userInformationEntity.getPersonalProfile())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PERSONAL_PROFILE_COMPLETE.getIndex());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userInfoEntity.getPhone())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.PHONE_COMPLETE.getIndex());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userInfoEntity.getWeixin())) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.WECHAT_COMPLETE.getIndex());
        }
        if (!CollectionUtils.isEmpty(userTagList = this.userTagService.getUserTagFromRedisDb(userInfoEntity.getId()))) {
            infoCompleteStatus = BitOperatorUtil.setBitToLong((Long)infoCompleteStatus, (int)InfoCombineStateEnum.USER_TAG_COMPLETE.getIndex());
        }
        return infoCompleteStatus;
    }

    @Override
    public Boolean getCompleteInformationWindow(Long userId) {
        log.debug("\u83b7\u53d6\u7528\u6237\u5b8c\u5584\u4e2a\u4eba\u8d44\u6599\u5f39\u7a97\uff0cuserId:[{}]", (Object)userId);
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userId);
        int status = InfoCombineStateEnum.getInfoUnCompleteStatus((Long)userInformationEntity.getInfoCompleteState());
        if (status >= 2) {
            KeyGenerator cacheKey = RedisConfig.USER_CACHE_POPUP.copy().appendKey((Object)userId);
            Map cacheMap = this.redisHashMapAdapter.entries(cacheKey, PopCache.class);
            PopCache popCache = (PopCache)cacheMap.get(KEY);
            if (Objects.isNull(popCache)) {
                popCache = new PopCache();
            }
            Long popTime = (Long)popCache.getParam(LAST_MODIFY_TIME);
            long timeMillis = System.currentTimeMillis();
            if (popTime == null || timeMillis - popTime > 604800000L) {
                popCache.setPopUp(Boolean.TRUE.booleanValue());
                popCache.addParam(LAST_MODIFY_TIME, (Object)System.currentTimeMillis());
                Integer num = (Integer)popCache.getParam("num");
                num = Objects.isNull(num) ? Integer.valueOf(1) : Integer.valueOf(num + 1);
                popCache.addParam("num", (Object)num);
                this.redisHashMapAdapter.put(cacheKey, KEY, (Object)popCache);
                log.debug("\u5f39\u51fa\u4e2a\u4eba\u8d44\u6599\u5f15\u5bfc\u5f39\u7a97:[{}]", (Object)JSONObject.toJSONString((Object)popCache));
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    private String getGeneration(Date brithday) {
        LocalDate birthday;
        String gen;
        String generationStr = "";
        if (null != brithday && !StringUtils.isEmpty((Object)(gen = this.userService.getGeneration(birthday = brithday.toInstant().atZone(ZoneId.systemDefault()).toLocalDate())))) {
            generationStr = gen;
        }
        return generationStr;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public UserAccountMaterialGuideDTO getAccountMaterialGuide(Long userId) {
        Boolean tips = (Boolean)this.redisHashMapAdapter.get(RedisConfig.ACCOUNT_MATERIAL_TIPS.copy(), userId.toString(), Boolean.class);
        if (tips == null) {
            this.redisHashMapAdapter.put(RedisConfig.ACCOUNT_MATERIAL_TIPS.copy(), userId.toString(), (Object)Boolean.FALSE);
        }
        Boolean perfect = (Boolean)this.redisHashMapAdapter.get(RedisConfig.ACCOUNT_MATERIAL_PERFECT.copy(), userId.toString(), Boolean.class);
        Set allMembers = this.redisSetAdapter.getAllMembers(RedisConfig.USER_LATELY_VISIT_NUM.copy().appendKey((Object)userId.toString()), Integer.class);
        int infoCompletePercent = 0;
        int perfectPercent = 100;
        if (perfect == null || !perfect.booleanValue()) {
            infoCompletePercent = this.getInfoCompletePercent(userId);
            if (infoCompletePercent == perfectPercent) {
                perfect = Boolean.TRUE;
                tips = Boolean.FALSE;
            } else {
                perfect = Boolean.FALSE;
            }
            this.redisHashMapAdapter.put(RedisConfig.ACCOUNT_MATERIAL_PERFECT.copy(), userId.toString(), (Object)perfect);
        }
        UserAccountMaterialGuideDTO userAccountMaterialGuideDTO = UserAccountMaterialGuideDTO.builder().build();
        userAccountMaterialGuideDTO.setInfoCompletePercent(Integer.valueOf(infoCompletePercent));
        userAccountMaterialGuideDTO.setTips(tips == null ? Boolean.TRUE : tips);
        userAccountMaterialGuideDTO.setCurrInterviewNum(Integer.valueOf(allMembers == null ? 0 : allMembers.size()));
        userAccountMaterialGuideDTO.setPerfect(perfect);
        return userAccountMaterialGuideDTO;
    }

    private int getInfoCompletePercent(Long userId) {
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userId);
        if (null == userInformationEntity) {
            return 0;
        }
        return InfoCombineStateEnum.getInfoCompletePercent((Long)(userInformationEntity.getInfoCompleteState() == null ? 0L : userInformationEntity.getInfoCompleteState()));
    }

    @Autowired
    public UserPersonalInfoServiceImpl(UserInfoMapper userInfoMapper, UserService userService, UserSyncService userSyncService, RedisHashMapAdapter redisHashMapAdapter, UserTagService userTagService, UserTagMapper userTagMapper, UserProperties userProperties, UserInformationMapper userInformationMapper, RedisSetAdapter redisSetAdapter, ApplicationContext applicationContext, BaseIntegrationService baseIntegrationService, UserInformationService userInformationService, UserLocationService userLocationService) {
        this.userInfoMapper = userInfoMapper;
        this.userService = userService;
        this.userSyncService = userSyncService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userTagService = userTagService;
        this.userTagMapper = userTagMapper;
        this.userProperties = userProperties;
        this.userInformationMapper = userInformationMapper;
        this.redisSetAdapter = redisSetAdapter;
        this.applicationContext = applicationContext;
        this.baseIntegrationService = baseIntegrationService;
        this.userInformationService = userInformationService;
        this.userLocationService = userLocationService;
    }
}

