/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.block.impl;

import com.bxm.egg.common.enums.AuthCodeEnum;
import com.bxm.egg.user.auth.UserAuthCodeService;
import com.bxm.egg.user.block.AdminBlockUserService;
import com.bxm.egg.user.constant.AdminBizConfigProperties;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.BlockUserTypeEnum;
import com.bxm.egg.user.integration.IMIntegrationService;
import com.bxm.egg.user.integration.PushMsgIntegrationService;
import com.bxm.egg.user.mapper.UserBlockMapper;
import com.bxm.egg.user.model.dto.block.UserBlockDTO;
import com.bxm.egg.user.model.entity.UserBlock;
import com.bxm.egg.user.model.param.RemoveAuthCodeParam;
import com.bxm.egg.user.param.UserAuthCodeParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminBlockUserServiceImpl
implements AdminBlockUserService {
    @Autowired
    private UserBlockMapper userBlockMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private IMIntegrationService imIntegrationService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Resource
    private UserAuthCodeService userAuthCodeService;
    @Autowired
    private AdminBizConfigProperties adminBizConfigProperties;
    @Autowired
    private PushMsgIntegrationService pushMsgIntegrationService;

    @Override
    public UserBlockDTO getInfo(Long userId) {
        List userBlockList = this.userBlockMapper.selectByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)userBlockList)) {
            return null;
        }
        return this.convert(userId, userBlockList);
    }

    @Override
    public Boolean editUserBlock(UserBlockDTO userBlockDTO) {
        Long userId = userBlockDTO.getUserId();
        Date blockTime = userBlockDTO.getBlockTime();
        ArrayList index = Lists.newArrayList();
        String actions = "";
        if (userBlockDTO.getChatLimitFlag().booleanValue()) {
            this.limit(userBlockDTO, BlockUserTypeEnum.CHAT_LIMIT, this.getChatLimitRedisKey(userId));
            this.imIntegrationService.block(userId, blockTime);
            actions = actions + "\u7981\u6b62\u79c1\u804a\u3001";
        } else {
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.CHAT_LIMIT, this.getChatLimitRedisKey(userId));
            this.imIntegrationService.unblock(userId);
        }
        if (userBlockDTO.getBlockFlag().booleanValue()) {
            this.limit(userBlockDTO, BlockUserTypeEnum.BLOCK_LIMIT, this.getBlockLimitRedisKey(userId));
            actions = actions + "\u62c9\u9ed1\u3001";
        } else {
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.BLOCK_LIMIT, this.getBlockLimitRedisKey(userId));
        }
        if (userBlockDTO.getForbidComment().booleanValue()) {
            actions = actions + "\u7981\u6b62\u8bc4\u8bba\u3001";
            this.addForbidUserAuth(AuthCodeEnum.FORBID_COMMENT, userBlockDTO.getUserId());
            this.limit(userBlockDTO, BlockUserTypeEnum.FORBID_COMMENT, this.getForbidCommentLimitRedisKey(userId));
            index.add(AuthCodeEnum.FORBID_COMMENT.index);
        } else {
            this.removeForbidUserAuth(AuthCodeEnum.FORBID_COMMENT, userBlockDTO.getUserId());
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.FORBID_COMMENT, this.getForbidCommentLimitRedisKey(userId));
        }
        if (userBlockDTO.getForbidPost().booleanValue()) {
            actions = actions + "\u7981\u6b62\u53d1\u5e16\u3001";
            this.addForbidUserAuth(AuthCodeEnum.FORBID_POST, userBlockDTO.getUserId());
            this.limit(userBlockDTO, BlockUserTypeEnum.FORBID_POST, this.getForbidPostLimitRedisKey(userId));
            index.add(AuthCodeEnum.FORBID_POST.index);
        } else {
            this.removeForbidUserAuth(AuthCodeEnum.FORBID_POST, userBlockDTO.getUserId());
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.FORBID_POST, this.getForbidPostLimitRedisKey(userId));
        }
        this.userAuthCodeService.removeAuthCodeTask(userBlockDTO.getUserId());
        if (CollectionUtils.isNotEmpty((Collection)index)) {
            RemoveAuthCodeParam param = RemoveAuthCodeParam.builder().authCodeIndex((List)index).expireTime(userBlockDTO.getBlockTime()).userId(userBlockDTO.getUserId()).build();
            this.userAuthCodeService.addRemoveAuthCodeTask(param);
        }
        if (StringUtils.isNotBlank((CharSequence)actions)) {
            if (actions.lastIndexOf(",") == actions.length() - 1) {
                actions = actions.substring(0, actions.length() - 1);
            }
            this.pushMsgIntegrationService.pushBlockMsg(actions, userBlockDTO.getBlockTime(), userBlockDTO.getUserId(), this.adminBizConfigProperties.getOfficialRulePostId());
        }
        return Boolean.TRUE;
    }

    private void addForbidUserAuth(AuthCodeEnum ennum, Long userId) {
        UserAuthCodeParam param = new UserAuthCodeParam();
        param.setAuthCode(ennum.index);
        param.setUserId(userId);
        AuthCodeEnum authCode = AuthCodeEnum.getByIndex((Integer)param.getAuthCode());
        this.userAuthCodeService.addAuthCode(param.getUserId(), authCode);
    }

    private void removeForbidUserAuth(AuthCodeEnum ennum, Long userId) {
        UserAuthCodeParam param = new UserAuthCodeParam();
        param.setAuthCode(ennum.index);
        param.setUserId(userId);
        AuthCodeEnum authCode = AuthCodeEnum.getByIndex((Integer)param.getAuthCode());
        this.userAuthCodeService.removeAuthCode(param.getUserId(), authCode);
    }

    private UserBlockDTO convert(Long userId, List<UserBlock> userBlockList) {
        UserBlockDTO userBlockDTO = UserBlockDTO.builder().userId(userId).blockTime(userBlockList.get(0).getBlockTime()).build();
        userBlockList.forEach(userBlock -> {
            if (BlockUserTypeEnum.CHAT_LIMIT.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getChatLimitRedisKey(userId)))) {
                userBlockDTO.setChatLimitFlag(Boolean.valueOf(true));
            }
            if (BlockUserTypeEnum.BLOCK_LIMIT.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getBlockLimitRedisKey(userId)))) {
                userBlockDTO.setBlockFlag(Boolean.valueOf(true));
            }
            if (BlockUserTypeEnum.FORBID_COMMENT.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getForbidCommentLimitRedisKey(userId)))) {
                userBlockDTO.setForbidComment(Boolean.valueOf(true));
            }
            if (BlockUserTypeEnum.FORBID_POST.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getForbidPostLimitRedisKey(userId)))) {
                userBlockDTO.setForbidPost(Boolean.valueOf(true));
            }
        });
        return userBlockDTO;
    }

    private void cancelLimit(UserBlockDTO userBlockDTO, BlockUserTypeEnum blockUserTypeEnum, KeyGenerator redisKey) {
        Long userId = userBlockDTO.getUserId();
        UserBlock userBlock = new UserBlock();
        userBlock.setUserId(userId);
        userBlock.setBlockType(blockUserTypeEnum.getBlockType());
        this.userBlockMapper.deleteByUserIdAndType(userBlock);
        if (Objects.nonNull(redisKey)) {
            this.redisStringAdapter.remove(redisKey);
        }
    }

    private void limit(UserBlockDTO userBlockDTO, BlockUserTypeEnum blockUserTypeEnum, KeyGenerator redisKey) {
        Date blockTime = userBlockDTO.getBlockTime();
        this.addRecord(userBlockDTO, blockUserTypeEnum.getBlockType());
        this.redisStringAdapter.set(redisKey, (Object)blockTime);
        this.redisStringAdapter.expire(redisKey, blockTime);
    }

    private void addRecord(UserBlockDTO userBlockDTO, Integer blockType) {
        UserBlock userBlock = UserBlock.builder().id(this.sequenceCreater.nextLongId()).userId(userBlockDTO.getUserId()).blockTime(userBlockDTO.getBlockTime()).blockType(blockType).build();
        this.userBlockMapper.deleteByUserIdAndType(userBlock);
        this.userBlockMapper.insertSelective(userBlock);
    }

    private KeyGenerator getChatLimitRedisKey(Long userId) {
        return RedisConfig.IM_BLOCK_LIST.copy().appendKey((Object)userId);
    }

    private KeyGenerator getBlockLimitRedisKey(Long userId) {
        return RedisConfig.USER_BLOCK_LIMIT.copy().appendKey((Object)userId);
    }

    private KeyGenerator getForbidCommentLimitRedisKey(Long userId) {
        return RedisConfig.FORBID_COMMENT_LIMIT.copy().appendKey((Object)userId);
    }

    private KeyGenerator getForbidPostLimitRedisKey(Long userId) {
        return RedisConfig.FORBID_POST_LIMIT.copy().appendKey((Object)userId);
    }
}

