/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.bxm.egg.mq.common.constant.MessageTypeEnum;
import com.bxm.egg.user.attribute.UserVisitService;
import com.bxm.egg.user.constant.UserEggRoleEnum;
import com.bxm.egg.user.info.UserBaseInfoService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.invite.UserInviteService;
import com.bxm.egg.user.medal.UserMedalService;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.bo.UserInformationBO;
import com.bxm.egg.user.model.dto.UserBaseInfoDTO;
import com.bxm.egg.user.model.dto.homepage.EggAccountDTO;
import com.bxm.egg.user.model.dto.homepage.EggAgentBusinessDTO;
import com.bxm.egg.user.model.dto.homepage.EggAgentInfoDTO;
import com.bxm.egg.user.model.dto.homepage.EggInviteDTO;
import com.bxm.egg.user.model.dto.homepage.EggPacketSimpleDTO;
import com.bxm.egg.user.model.dto.homepage.EggUserRoleDTO;
import com.bxm.egg.user.model.dto.info.UserBriefInfoDTO;
import com.bxm.egg.user.model.dto.info.UserDetailInfoDTO;
import com.bxm.egg.user.model.dto.medal.UserMedalDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.properties.UserMedalProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.role.UserEggRoleService;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserBaseInfoServiceImpl
implements UserBaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(UserBaseInfoServiceImpl.class);
    private final UserInfoCacheService userInfoCacheService;
    private final UserProperties userProperties;
    private final UserMedalProperties userMedalProperties;
    private final UserInfoService userInfoService;
    private final UserStatisticsService userStatisticsService;
    private final UserInformationService userInformationService;
    private final UserVisitService userVisitService;
    private final MessageFacadeIntegrationService messageFacadeIntegrationService;
    private final UserInviteService userInviteService;
    private final UserMedalService userMedalService;
    private final UserWarmLevelService userWarmLevelService;
    private final UserEggRoleService userEggRoleService;

    @Override
    public List<UserBriefInfoDTO> getUserBriefInfo(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_LIST;
        }
        return userIdList.stream().map(this::getUserBriefInfo).collect(Collectors.toList());
    }

    @Override
    public List<UserDetailInfoDTO> getUserDetailInfo(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_LIST;
        }
        return userIdList.stream().map(this::getUserDetailInfo).collect(Collectors.toList());
    }

    private UserBriefInfoDTO getUserBriefInfo(Long userId) {
        UserBriefInfoDTO userBriefInfoDTO = new UserBriefInfoDTO();
        UserCacheInfoBO userCacheInfo = this.userInfoCacheService.load(userId);
        BeanUtils.copyProperties((Object)userCacheInfo, (Object)userBriefInfoDTO);
        UserEquityDTO userWarmLevelDTO = userCacheInfo.getUserWarmLevelDTO();
        boolean dazzling = userWarmLevelDTO != null && userWarmLevelDTO.getDazzling() != null && userWarmLevelDTO.getDazzling() != false;
        userBriefInfoDTO.setDazzling(Boolean.valueOf(dazzling));
        return userBriefInfoDTO;
    }

    @Override
    public UserBaseInfoDTO getUserPersonalCenterInfo(Long userId) {
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(userId);
        UserStatisticsEntity userStatisticsEntity = this.userStatisticsService.selectUserStatisticsByUserId(userId);
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userId);
        if (null == userInfoEntity) {
            return null;
        }
        UserBaseInfoDTO userBaseInfoDTO = new UserBaseInfoDTO();
        userBaseInfoDTO.setNickname(StringUtils.isBlank((CharSequence)userInfoEntity.getNickname()) ? com.bxm.newidea.component.tools.StringUtils.hideMobile((String)userInfoEntity.getPhone()) : userInfoEntity.getNickname());
        userBaseInfoDTO.setHeadImg(StringUtils.isBlank((CharSequence)userInfoEntity.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : userInfoEntity.getHeadImg());
        userBaseInfoDTO.setForumNum(userStatisticsEntity.getPostNum());
        userBaseInfoDTO.setSex(userInfoEntity.getSex());
        userBaseInfoDTO.setAttentionNum(userStatisticsEntity.getAttentionNum());
        userBaseInfoDTO.setFanNum(userStatisticsEntity.getFanNum());
        userBaseInfoDTO.setPersonalProfile(userInformationEntity.getPersonalProfile());
        userBaseInfoDTO.setAllInterviewNum(this.userVisitService.getInterviewNumByUserId(userId));
        userBaseInfoDTO.setUnReadFanNum(this.messageFacadeIntegrationService.getUnReadMessageNum(userId, MessageTypeEnum.ADD_FUNS));
        userBaseInfoDTO.setTodayInterviewNum(this.userVisitService.getTodayVisitorNum(userId));
        userBaseInfoDTO.setInviteUserHeadImgList(this.userInviteService.getLastInviteUserHeadImgList(userId));
        int userMedalNum = this.userMedalService.getUserMedalNum(userId);
        UserMedalDTO userMedalDTO = new UserMedalDTO();
        userMedalDTO.setMedalIconUrl(this.userMedalProperties.getMyPageMedalUrl());
        userMedalDTO.setMedalNum(Integer.valueOf(userMedalNum));
        userBaseInfoDTO.setUserMedalDTO(userMedalDTO);
        userBaseInfoDTO.setEquityDTO(this.userWarmLevelService.getUserWarmInfoCache(userId).getEquityDTO());
        this.fillEggRoleInfo(userId, userBaseInfoDTO);
        this.fillEggAgentAndBusiness(userId, userBaseInfoDTO);
        this.fillEggPacketInfo(userId, userBaseInfoDTO);
        this.fillEggAccountInfo(userId, userBaseInfoDTO);
        this.fillInviteInfo(userId, userBaseInfoDTO);
        return userBaseInfoDTO;
    }

    private void fillInviteInfo(Long userId, UserBaseInfoDTO userBaseInfoDTO) {
        EggInviteDTO eggInviteDTO = new EggInviteDTO();
        eggInviteDTO.setInviteNum(Integer.valueOf(10));
        eggInviteDTO.setInviteEggNum(Integer.valueOf(4));
        eggInviteDTO.setInviteFoodsNum(Integer.valueOf(20));
        eggInviteDTO.setInviteHeadImgList(Arrays.asList("https://m.wstong.com/localnews_prod/avatar/2/2.jpeg", "https://bxm-news-dev.oss-cn-hangzhou.aliyuncs.com/localnews_dev/avatar/3/H8UKWHWU7GE2K4XRWD28XVWB7XDO147ALNBRJ1.jpeg", "https://m.wstong.com/localnews_prod/avatar/6/6.jpeg"));
        userBaseInfoDTO.setEggInviteDTO(eggInviteDTO);
    }

    private void fillEggAccountInfo(Long userId, UserBaseInfoDTO userBaseInfoDTO) {
        EggAccountDTO eggAccountDTO = new EggAccountDTO();
        eggAccountDTO.setEggCouponNum(Integer.valueOf(20));
        eggAccountDTO.setFoodsNum(Integer.valueOf(50));
        eggAccountDTO.setCardNum(Integer.valueOf(110));
        userBaseInfoDTO.setEggAccountDTO(eggAccountDTO);
    }

    private void fillEggPacketInfo(Long userId, UserBaseInfoDTO userBaseInfoDTO) {
        EggPacketSimpleDTO eggPacketSimpleDTO = new EggPacketSimpleDTO();
        eggPacketSimpleDTO.setEnableAmount(BigDecimal.valueOf(1412.1));
        userBaseInfoDTO.setEggPacketSimpleDTO(eggPacketSimpleDTO);
    }

    private void fillEggAgentAndBusiness(Long userId, UserBaseInfoDTO userBaseInfoDTO) {
        EggUserRoleDTO eggUserRoleDTO = userBaseInfoDTO.getEggUserRoleDTO();
        List roleTypeList = eggUserRoleDTO.getRoleTypeList();
        if (roleTypeList.contains(UserEggRoleEnum.COMMUNITY_AGENT.getCode()) || roleTypeList.contains(UserEggRoleEnum.COUNTY_AGENT.getCode()) || roleTypeList.contains(UserEggRoleEnum.CITY_AGENT.getCode())) {
            EggAgentInfoDTO eggAgentInfoDTO = new EggAgentInfoDTO();
            eggAgentInfoDTO.setCooperatorNum(Integer.valueOf(10));
            eggAgentInfoDTO.setDeviceNum(Integer.valueOf(10));
            EggAgentBusinessDTO eggAgentBusinessDTO = new EggAgentBusinessDTO();
            eggAgentBusinessDTO.setDayOrderNum(Integer.valueOf(30));
            eggAgentBusinessDTO.setWeekOrderNum(Integer.valueOf(40));
            eggAgentBusinessDTO.setMonthOrderNum(Integer.valueOf(50));
            userBaseInfoDTO.setEggAgentInfoDTO(eggAgentInfoDTO);
            userBaseInfoDTO.setEggAgentBusinessDTO(eggAgentBusinessDTO);
        } else if (roleTypeList.contains(UserEggRoleEnum.BUSINESS.getCode())) {
            EggAgentBusinessDTO eggAgentBusinessDTO = new EggAgentBusinessDTO();
            eggAgentBusinessDTO.setDayOrderNum(Integer.valueOf(60));
            eggAgentBusinessDTO.setWeekOrderNum(Integer.valueOf(70));
            eggAgentBusinessDTO.setMonthOrderNum(Integer.valueOf(80));
            userBaseInfoDTO.setEggAgentBusinessDTO(eggAgentBusinessDTO);
        }
    }

    private void fillEggRoleInfo(Long userId, UserBaseInfoDTO userBaseInfoDTO) {
        List<Integer> userRoleType = this.userEggRoleService.getUserRoleType(userId);
        EggUserRoleDTO eggUserRoleDTO = new EggUserRoleDTO();
        eggUserRoleDTO.setRoleTypeList(userRoleType);
        userBaseInfoDTO.setEggUserRoleDTO(eggUserRoleDTO);
    }

    private UserDetailInfoDTO getUserDetailInfo(Long userId) {
        UserDetailInfoDTO userDetailInfoDTO = new UserDetailInfoDTO();
        UserCacheInfoBO userCacheInfo = this.userInfoCacheService.load(userId);
        BeanUtils.copyProperties((Object)userCacheInfo, (Object)userDetailInfoDTO);
        UserEquityDTO userWarmLevelDTO = userCacheInfo.getUserWarmLevelDTO();
        boolean dazzling = userWarmLevelDTO != null && userWarmLevelDTO.getDazzling() != null && userWarmLevelDTO.getDazzling() != false;
        userDetailInfoDTO.setDazzling(Boolean.valueOf(dazzling));
        UserInformationBO userInformationBO = userCacheInfo.getUserInformationBO();
        userDetailInfoDTO.setPersonalProfile(userInformationBO.getPersonalProfile());
        userDetailInfoDTO.setWearMedalList(userCacheInfo.getWearMedalList());
        userDetailInfoDTO.setUserWarmLevelDTO(userCacheInfo.getUserWarmLevelDTO());
        return userDetailInfoDTO;
    }

    public UserBaseInfoServiceImpl(UserInfoCacheService userInfoCacheService, UserProperties userProperties, UserMedalProperties userMedalProperties, UserInfoService userInfoService, UserStatisticsService userStatisticsService, UserInformationService userInformationService, UserVisitService userVisitService, MessageFacadeIntegrationService messageFacadeIntegrationService, UserInviteService userInviteService, UserMedalService userMedalService, UserWarmLevelService userWarmLevelService, UserEggRoleService userEggRoleService) {
        this.userInfoCacheService = userInfoCacheService;
        this.userProperties = userProperties;
        this.userMedalProperties = userMedalProperties;
        this.userInfoService = userInfoService;
        this.userStatisticsService = userStatisticsService;
        this.userInformationService = userInformationService;
        this.userVisitService = userVisitService;
        this.messageFacadeIntegrationService = messageFacadeIntegrationService;
        this.userInviteService = userInviteService;
        this.userMedalService = userMedalService;
        this.userWarmLevelService = userWarmLevelService;
        this.userEggRoleService = userEggRoleService;
    }
}

