/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.bxm.egg.user.info.UserExtendService;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class UserExtendServiceImpl
implements UserExtendService {
    private static final Logger log = LoggerFactory.getLogger(UserExtendServiceImpl.class);
    private AliyunOSSService aliyunOSSService;
    private UserProperties userProperties;

    @Override
    public String uploadWechatImage(String headImg, BasicParam param, Long userId) {
        if (null == headImg) {
            return null;
        }
        try {
            if (StringUtils.endsWith((CharSequence)headImg, (CharSequence)"132")) {
                headImg = headImg.substring(0, headImg.length() - 3) + "0";
            } else if (StringUtils.endsWith((CharSequence)headImg, (CharSequence)"96") || StringUtils.endsWith((CharSequence)headImg, (CharSequence)"64") || StringUtils.endsWith((CharSequence)headImg, (CharSequence)"46")) {
                headImg = headImg.substring(0, headImg.length() - 2) + "0";
            }
            URL url = new URL(headImg);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            InputStream inputStream = null;
            if (conn.getResponseCode() == HttpStatus.OK.value()) {
                inputStream = conn.getInputStream();
                log.debug("\u6839\u636eurl\u83b7\u5f97\u56fe\u7247\u7684\u6d41\u72b6\u6001\uff1a{}", (Object)inputStream.available());
            }
            if (userId == null) {
                userId = SequenceHolder.nextLongId();
            }
            int hashCode = (int)(userId % 100L);
            String path = "";
            if (null != param.getSrcApp()) {
                path = param.getSrcApp() + "/";
            }
            String datePath = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
            path = path + "avatar/" + datePath + hashCode + "/" + Long.toHexString(userId) + ".jpeg";
            return this.aliyunOSSService.upload(inputStream, path) + "?x-oss-process=style/head";
        }
        catch (IOException e) {
            log.error("\u5fae\u4fe1\u6388\u6743\u4e0a\u4f20\u5934\u50cf\u51fa\u9519\uff0c\u4f7f\u7528\u9ed8\u8ba4\u5934\u50cf\uff0c\u7528\u6237id:[{}],\u7528\u6237\u5934\u50cf:[{}],\u9519\u8bef:[{}]", new Object[]{userId, headImg, e.getMessage()});
            headImg = this.userProperties.getDefaultHeadImagUrl();
            return headImg;
        }
    }

    public UserExtendServiceImpl(AliyunOSSService aliyunOSSService, UserProperties userProperties) {
        this.aliyunOSSService = aliyunOSSService;
        this.userProperties = userProperties;
    }
}

