/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.bo.UserStatisticsBO;
import com.bxm.egg.user.facade.service.UserInfoFacadeService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.bo.UserLocationBO;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@DubboService(protocol={"dubbo"}, version="1.0.0")
public class UserInfoFacadeServiceImpl
implements UserInfoFacadeService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoFacadeServiceImpl.class);
    @Resource
    private UserInfoCacheService userInfoCacheService;
    @Resource
    private UserStatisticsService userStatisticsService;
    @Resource
    private UserInformationService userInformationService;

    public UserInfoBO selectUserFromCache(Long userId) {
        UserCacheInfoBO userCacheInfoBO = this.userInfoCacheService.load(userId);
        UserInfoBO userInfoBO = new UserInfoBO();
        BeanUtils.copyProperties((Object)userCacheInfoBO, (Object)userInfoBO);
        UserLocationBO userLocationBO = userCacheInfoBO.getUserLocationBO();
        if (userLocationBO != null) {
            userInfoBO.setLocationCode(userLocationBO.getLocationCode());
            userInfoBO.setLocationName(userLocationBO.getLocationName());
        }
        return userInfoBO;
    }

    public List<UserInfoBO> selectUserListFromCache(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_LIST;
        }
        return userIdList.stream().map(this::selectUserFromCache).collect(Collectors.toList());
    }

    public UserStatisticsBO getUserStatisticsInfo(Long userId) {
        UserStatisticsEntity userStatisticsEntity = this.userStatisticsService.selectUserStatisticsByUserId(userId);
        UserStatisticsBO userStatisticsBO = new UserStatisticsBO();
        if (userStatisticsEntity != null) {
            BeanUtils.copyProperties((Object)userStatisticsEntity, (Object)userStatisticsBO);
        }
        return userStatisticsBO;
    }

    public Long getInfoCompleteState(Long userId) {
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationById(userId);
        if (userInformationEntity != null) {
            return userInformationEntity.getInfoCompleteState();
        }
        return 0L;
    }
}

