/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.constant.UserStateEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.mapper.UserAccountMapper;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.mapper.UserInfoMapper;
import com.bxm.egg.user.mapper.UserInformationMapper;
import com.bxm.egg.user.mapper.UserLocationMapper;
import com.bxm.egg.user.mapper.UserStatisticsMapper;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.model.param.login.canel.CancelUserParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserInfoServiceImpl
implements UserInfoService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoServiceImpl.class);
    @Resource
    private UserInfoMapper userInfoMapper;
    @Resource
    private UserGrantWechatAppMapper userGrantWechatAppMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private UserInformationMapper userInformationMapper;
    @Resource
    private UserStatisticsMapper userStatisticsMapper;
    @Resource
    private UserLocationMapper userLocationMapper;
    @Resource
    private UserAccountMapper userAccountMapper;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private UserProperties userProperties;

    private UserCacheInfoBO convertToCacheInfo(UserInfoEntity userInfoEntity) {
        UserCacheInfoBO userCacheInfoBO = new UserCacheInfoBO();
        BeanUtils.copyProperties((Object)userInfoEntity, (Object)userCacheInfoBO);
        userCacheInfoBO.setUserId(userInfoEntity.getId());
        return userCacheInfoBO;
    }

    @Override
    public Boolean cancelUser(CancelUserParam cancelUserParam) {
        return null;
    }

    @Override
    public Long generateUserId(BasicParam param) {
        return this.sequenceCreater.nextLongId();
    }

    @Override
    public void updateStatus(Long userId, UserStateEnum status) {
    }

    @Override
    public Optional<Long> userUnionIdExist(String unionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, (Object)unionId);
        List userGrantWechatAppEntityList = this.userGrantWechatAppMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)userGrantWechatAppEntityList)) {
            return Optional.of(((UserGrantWechatAppEntity)userGrantWechatAppEntityList.get(0)).getUserId());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> userPhoneExist(String phone) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInfoEntity::getPhone, (Object)phone);
        List userWechatAppEntityList = this.userInfoMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)userWechatAppEntityList)) {
            return Optional.of(((UserInfoEntity)userWechatAppEntityList.get(0)).getId());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> userUsernameExist(String username) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInfoEntity::getUsername, (Object)username);
        List userInfoEntityList = this.userInfoMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)userInfoEntityList)) {
            return Optional.of(((UserInfoEntity)userInfoEntityList.get(0)).getId());
        }
        return Optional.empty();
    }

    @Override
    public boolean checkUserPassword(Long userId, String username, String password) {
        UserInfoEntity userInfoEntity = (UserInfoEntity)this.userInfoMapper.selectById((Serializable)userId);
        String targetPassword = MD5Util.encode((String)password, (String)userInfoEntity.getSalt());
        String realPassword = userInfoEntity.getPassword();
        return Objects.equals(targetPassword, realPassword);
    }

    @Override
    public void updateUserPassword(Long userId, String password) {
        UserInfoEntity dbUserInfo = (UserInfoEntity)this.userInfoMapper.selectById((Serializable)userId);
        String salt = dbUserInfo.getSalt();
        UserInfoEntity userInfoEntity = new UserInfoEntity();
        userInfoEntity.setId(userId);
        userInfoEntity.setPassword(MD5Util.encode((String)password, (String)salt));
        this.userInfoMapper.updateById((Object)userInfoEntity);
    }

    @Override
    public boolean hasSettingPassword(String username) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserInfoEntity::getUsername, (Object)username);
        List userInfoEntityList = this.userInfoMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)userInfoEntityList)) {
            return StringUtils.isNotBlank((CharSequence)((UserInfoEntity)userInfoEntityList.get(0)).getPassword());
        }
        log.error("\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff0c\u7528\u6237\u540d\uff1a{}", (Object)username);
        return false;
    }

    @Override
    public void bindPhone(Long userId, String phone) {
        UserInfoEntity userInfoEntity = new UserInfoEntity();
        userInfoEntity.setId(userId);
        userInfoEntity.setPhone(phone);
        this.userInfoMapper.updateById((Object)userInfoEntity);
    }

    @Override
    public void bindUsername(Long userId, String username) {
        UserInfoEntity userInfoEntity = new UserInfoEntity();
        userInfoEntity.setId(userId);
        userInfoEntity.setUsername(username);
        this.userInfoMapper.updateById((Object)userInfoEntity);
    }

    @Override
    public UserInfoEntity selectUserById(Long userId) {
        return (UserInfoEntity)this.userInfoMapper.selectById((Serializable)userId);
    }

    @Override
    public void initUserExtendData(UserInfoEntity newUser) {
        UserInformationEntity newUserInformation = new UserInformationEntity();
        newUserInformation.setId(this.sequenceCreater.nextLongId());
        newUserInformation.setUserId(newUser.getId());
        this.userInformationMapper.insert((Object)newUserInformation);
        UserStatisticsEntity newUserStatisticsEntity = new UserStatisticsEntity();
        newUserStatisticsEntity.setId(this.sequenceCreater.nextLongId());
        newUserStatisticsEntity.setUserId(newUser.getId());
        this.userStatisticsMapper.insert((Object)newUserStatisticsEntity);
        UserLocationEntity newUserLocationEntity = new UserLocationEntity();
        newUserLocationEntity.setId(this.sequenceCreater.nextLongId());
        newUserLocationEntity.setUserId(newUser.getId());
        this.userLocationMapper.insert((Object)newUserLocationEntity);
        UserAccountEntity newUserAccountEntity = new UserAccountEntity();
        newUserAccountEntity.setId(this.sequenceCreater.nextLongId());
        newUserAccountEntity.setUserId(newUser.getId());
        this.userAccountMapper.insert((Object)newUserAccountEntity);
    }
}

