/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.equitylevelmedal.UserEquityLevelMedalService;
import com.bxm.egg.user.info.UserManageService;
import com.bxm.egg.user.mapper.UserInfoMapper;
import com.bxm.egg.user.model.dto.manage.info.UserManageListDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelInfoDTO;
import com.bxm.egg.user.model.param.manage.info.UserManageQueryParam;
import com.bxm.newidea.component.dto.IPageModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserManageServiceImpl
implements UserManageService {
    private static final Logger log = LoggerFactory.getLogger(UserManageServiceImpl.class);
    @Resource
    private UserInfoMapper userInfoMapper;
    @Resource
    private UserEquityLevelMedalService userEquityLevelMedalService;

    @Override
    public IPageModel<UserManageListDTO> getUserList(UserManageQueryParam param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        IPage pageResult = this.userInfoMapper.queryUserInfoList((IPage)page, param);
        if (!CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            ArrayList userIdList = Lists.newArrayList();
            pageResult.getRecords().forEach(item -> userIdList.add(item.getUserId()));
            List<UserEquityLevelInfoDTO> equityLevelInfoList = this.userEquityLevelMedalService.getEquityLevelInfoList(userIdList, false);
            if (!equityLevelInfoList.isEmpty()) {
                Map<Long, List<UserEquityLevelInfoDTO>> equityLevelMap = equityLevelInfoList.stream().collect(Collectors.groupingBy(UserEquityLevelInfoDTO::getUserId));
                pageResult.getRecords().forEach(user -> {
                    List userEquityLevelMedalInfoDTOS = (List)equityLevelMap.get(user.getUserId());
                    if (!userEquityLevelMedalInfoDTOS.isEmpty()) {
                        user.setWarmLevel(((UserEquityLevelInfoDTO)userEquityLevelMedalInfoDTOS.get(0)).getUserEquityDTO().getLevel());
                    }
                });
            }
            pageResult.getRecords().forEach(userInfo -> userInfo.setMedalNum(Integer.valueOf(this.userEquityLevelMedalService.getUserMedalNum(userInfo.getUserId()))));
        }
        return PlusPageModelDTO.build((IPage)page);
    }
}

