/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.invite;

import com.bxm.egg.user.invite.InviteTypeProcessor;
import com.bxm.egg.user.invite.processor.DefaultInviteTypeProcessor;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InviteTypeProcessorManager {
    private Map<String, InviteTypeProcessor> processorMap = Maps.newHashMap();
    private DefaultInviteTypeProcessor defaultProcessor;

    @Autowired
    public InviteTypeProcessorManager(List<InviteTypeProcessor> processors, DefaultInviteTypeProcessor defaultProcessor) {
        if (null != processors) {
            processors.forEach(processor -> this.processorMap.put(processor.support().getName(), (InviteTypeProcessor)processor));
        }
        this.defaultProcessor = defaultProcessor;
    }

    public InviteTypeProcessor obtain(String inviteType) {
        return this.processorMap.getOrDefault(inviteType, this.defaultProcessor);
    }
}

