/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.invite.bind;

import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.enums.InviteBindMethodEnum;
import com.bxm.egg.user.facade.ForumPostFacadeService;
import com.bxm.egg.user.facade.MerchantFeignService;
import com.bxm.egg.user.invite.UserInviteService;
import com.bxm.egg.user.login.UserService;
import com.bxm.egg.user.mapper.UserInviteHistoryMapper;
import com.bxm.egg.user.mapper.UserMapper;
import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.egg.user.model.vo.User;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.egg.user.vo.ForumPostVo;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractBindInviteStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractBindInviteStrategy.class);
    @Resource
    private UserInviteHistoryMapper userInviteHistoryMapper;
    @Resource
    private ForumPostFacadeService forumPostFacadeService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserService userService;
    @Resource
    private MerchantFeignService merchantFeignService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private UserInviteService userInviteService;

    private UserInviteService getUserInviteService() {
        if (this.userInviteService == null) {
            this.userInviteService = (UserInviteService)SpringContextHolder.getBean(UserInviteService.class);
        }
        return this.userInviteService;
    }

    private Message preCheckCommon(UserInviteBindDTO userInviteBindDTO) {
        if (null == userInviteBindDTO.getUser()) {
            userInviteBindDTO.setUser(this.userMapper.selectByPrimaryKey(userInviteBindDTO.getUserId()));
            if (null == userInviteBindDTO.getInviteUserId()) {
                userInviteBindDTO.setInviteUserId(userInviteBindDTO.getUser().getInviteUserId());
            }
        }
        if (null == userInviteBindDTO.getInviteUserId() || Objects.equals(userInviteBindDTO.getUserId(), userInviteBindDTO.getInviteUserId())) {
            return Message.build((boolean)false);
        }
        UserInviteHistoryBean inviteBean = this.userInviteHistoryMapper.selectByUserId(userInviteBindDTO.getUserId());
        if (null == inviteBean) {
            userInviteBindDTO.setAlreadyHas(Boolean.valueOf(false));
            this.setInviteBean(userInviteBindDTO);
        } else {
            userInviteBindDTO.setAlreadyHas(Boolean.valueOf(true));
            userInviteBindDTO.setUserInviteHistoryBean(inviteBean);
            if (Objects.equals(inviteBean.getState(), (byte)1)) {
                this.beNormalInviteAfter(userInviteBindDTO);
                return Message.build((boolean)false);
            }
        }
        return Message.build((boolean)true);
    }

    protected abstract Message preInvoke(UserInviteBindDTO var1);

    protected Message afterInviteNormal(UserInviteBindDTO userInviteBindDTO) {
        this.merchantFeignService.insertMerchantInvite(userInviteBindDTO.getUserInviteHistoryBean());
        return Message.build((boolean)true);
    }

    protected Message afterInviteNotActive(UserInviteBindDTO userInviteBindDTO) {
        User user = new User();
        user.setId(userInviteBindDTO.getUser().getId());
        user.setInviteUserId(userInviteBindDTO.getInviteUserId());
        this.userMapper.updateByPrimaryKeySelective(user);
        this.userService.loadUserToRedis(user.getId());
        return Message.build((boolean)true);
    }

    private Message afterInsertInviteNormal(UserInviteBindDTO userInviteBindDTO) {
        this.afterInviteNotActive(userInviteBindDTO);
        return this.afterInviteNormal(userInviteBindDTO);
    }

    public final UserInviteHistoryBean doBindInvite(UserInviteBindDTO userInviteBindDTO) {
        Message message = this.preCheckCommon(userInviteBindDTO);
        if (!message.isSuccess()) {
            if (null != userInviteBindDTO.getUserInviteHistoryBean() && userInviteBindDTO.getAlreadyHas().booleanValue()) {
                return userInviteBindDTO.getUserInviteHistoryBean();
            }
            return null;
        }
        message = this.preInvoke(userInviteBindDTO);
        if (message.isSuccess()) {
            this.replenishInviteHistory(userInviteBindDTO.getUserInviteHistoryBean());
            if (this.getUserInviteService().insertOrUpdate(userInviteBindDTO).booleanValue()) {
                if (userInviteBindDTO.getAlreadyHas().booleanValue()) {
                    this.afterInviteNormal(userInviteBindDTO);
                } else if (Objects.equals((byte)1, userInviteBindDTO.getUserInviteHistoryBean().getState())) {
                    this.afterInsertInviteNormal(userInviteBindDTO);
                } else if (Objects.equals((byte)2, userInviteBindDTO.getUserInviteHistoryBean().getState())) {
                    this.afterInviteNotActive(userInviteBindDTO);
                }
                return userInviteBindDTO.getUserInviteHistoryBean();
            }
        }
        return null;
    }

    protected abstract InviteBindMethodEnum getBindMethod();

    protected void beNormalInviteAfter(UserInviteBindDTO userInviteBindDTO) {
    }

    protected void replenishInviteHistory(UserInviteHistoryBean entity) {
        UserInviteHistoryBean inviteHistoryBean;
        if (null == entity.getInviteUserId()) {
            return;
        }
        log.info("\u80fd\u5426\u8fdb\u5165\u5230\u521b\u4f5c\u8005\u7684\u4fe1\u606f[{}]", (Object)(null != entity.getRelationId() && StringUtils.equals((CharSequence)entity.getType(), (CharSequence)InviteTypeEnum.FORUM.getName()) ? 1 : 0));
        if (null != entity.getRelationId() && StringUtils.equals((CharSequence)entity.getType(), (CharSequence)InviteTypeEnum.FORUM.getName())) {
            ForumPostVo forumPostVo = (ForumPostVo)this.forumPostFacadeService.getForumPostById(entity.getRelationId()).getBody();
            log.info("\u8fdb\u6765\uff0c\u5e76\u4e14\u83b7\u53d6\u5230\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)forumPostVo));
            if (null != forumPostVo && null != forumPostVo.getUserId()) {
                entity.setCreatedUserId(forumPostVo.getUserId());
                entity.setRelationTitle(StringUtils.substring((String)forumPostVo.getTitle(), (int)0, (int)20));
            }
        }
        if (null == (inviteHistoryBean = this.userInviteHistoryMapper.selectByUserId(entity.getInviteUserId())) || null == inviteHistoryBean.getUserId()) {
            return;
        }
        entity.setInviteSuperUserId(inviteHistoryBean.getInviteUserId());
        entity.setInviteCreatedUserId(inviteHistoryBean.getCreatedUserId());
    }

    private void setInviteBean(UserInviteBindDTO userInviteBindDTO) {
        UserInviteHistoryBean bean = new UserInviteHistoryBean();
        bean.setUserId(userInviteBindDTO.getUserId());
        bean.setInviteUserId(userInviteBindDTO.getInviteUserId());
        bean.setRelationId(userInviteBindDTO.getUser().getRelationId());
        bean.setRelationTitle(userInviteBindDTO.getRelationTitle());
        bean.setCreateTime(new Date());
        bean.setInviteHeadImg(userInviteBindDTO.getUser().getHeadImg());
        bean.setInviteUserNickname(userInviteBindDTO.getUser().getNickname());
        bean.setType(this.getBindMethod().name());
        bean.setState(userInviteBindDTO.getUser().getState());
        bean.setBindTime(new Date());
        userInviteBindDTO.setUserInviteHistoryBean(bean);
    }
}

