/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.invite.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.attribute.UserAttributeService;
import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.enums.InviteBindMethodEnum;
import com.bxm.egg.user.integration.LocationIntegrationService;
import com.bxm.egg.user.invite.InviteProcessService;
import com.bxm.egg.user.invite.UserInviteService;
import com.bxm.egg.user.login.UserService;
import com.bxm.egg.user.mapper.UserInviteHistoryMapper;
import com.bxm.egg.user.model.dto.InviteCounterDTO;
import com.bxm.egg.user.model.dto.UserInfoDTO;
import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.egg.user.model.dto.UserInviteCollectDTO;
import com.bxm.egg.user.model.dto.UserInviteDTO;
import com.bxm.egg.user.model.param.UserInviteConterParam;
import com.bxm.egg.user.model.param.UserInvitePageParam;
import com.bxm.egg.user.model.vo.Tuple;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.egg.user.model.vo.UserInviteOrderVO;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.support.VirtualUserService;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInviteServiceImpl
implements UserInviteService {
    private static final Logger log = LoggerFactory.getLogger(UserInviteServiceImpl.class);
    private final UserInviteHistoryMapper userInviteHistoryMapper;
    private InviteProcessService inviteProcessService;
    private UserAttributeService userAttributeService;
    private final UserProperties userProperties;
    private UserService userService;
    private final LocationIntegrationService locationIntegrationService;
    private final VirtualUserService virtualUserService;

    @Autowired
    public UserInviteServiceImpl(UserInviteHistoryMapper userInviteHistoryMapper, UserAttributeService userAttributeService, UserProperties userProperties, LocationIntegrationService locationIntegrationService, VirtualUserService virtualUserService) {
        this.userInviteHistoryMapper = userInviteHistoryMapper;
        this.userAttributeService = userAttributeService;
        this.userProperties = userProperties;
        this.locationIntegrationService = locationIntegrationService;
        this.virtualUserService = virtualUserService;
    }

    private InviteProcessService getInviteProcessService() {
        if (this.inviteProcessService == null) {
            this.inviteProcessService = (InviteProcessService)SpringContextHolder.getBean(InviteProcessService.class);
        }
        return this.inviteProcessService;
    }

    public UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)SpringContextHolder.getBean(UserService.class);
        }
        return this.userService;
    }

    @Override
    public UserInviteCollectDTO getInviteCollect(Long userId) {
        UserInvitePageParam param = new UserInvitePageParam();
        param.setUserId(userId);
        UserInviteCollectDTO result = this.getCollect(userId);
        result.setFirstPage(this.getInviteByPage(param));
        return result;
    }

    private UserInviteCollectDTO getCollect(Long userId) {
        List collectList = this.userInviteHistoryMapper.getCollect(userId);
        String todayFormat = DateUtils.formatDate((Date)new Date());
        Calendar yesterdayCalendar = Calendar.getInstance();
        yesterdayCalendar.setTime(new Date());
        yesterdayCalendar.add(6, -1);
        String yesterdayFormat = DateUtils.formatDate((Date)yesterdayCalendar.getTime());
        int total = 0;
        int today = 0;
        int yesterday = 0;
        for (Tuple tuple : collectList) {
            total += tuple.getTotal();
            if (StringUtils.equals((CharSequence)todayFormat, (CharSequence)tuple.getLabel())) {
                today = tuple.getTotal();
            }
            if (!StringUtils.equals((CharSequence)yesterdayFormat, (CharSequence)tuple.getLabel())) continue;
            yesterday = tuple.getTotal();
        }
        Integer levelOne = this.userInviteHistoryMapper.getCollectLevel(userId, Integer.valueOf(1));
        Integer levelTwo = this.userInviteHistoryMapper.getCollectLevel(userId, Integer.valueOf(2));
        UserInviteCollectDTO result = new UserInviteCollectDTO();
        result.setTodayTotal(Integer.valueOf(today));
        result.setYesterdayTotal(Integer.valueOf(yesterday));
        result.setTotal(Integer.valueOf(total));
        result.setOneLevel(levelOne);
        result.setTwoLevel(levelTwo);
        int nonActivated = total - levelOne - levelTwo;
        result.setNonActivated(Integer.valueOf(nonActivated < 0 ? 0 : nonActivated));
        return result;
    }

    @Override
    public IPageModel<UserInviteDTO> getInviteByPage(UserInvitePageParam param) {
        Page queryParam = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        IPage pageResult = this.userInviteHistoryMapper.queryByPage((IPage)queryParam, param);
        PlusPageModelDTO resultList = PlusPageModelDTO.build((IPage)pageResult);
        resultList.changeList(this.convert(param.getUserId(), pageResult.getRecords()));
        return resultList;
    }

    @Override
    public List<String> getLastInviteUserHeadImgList(Long userId) {
        return this.userInviteHistoryMapper.getLastInviteHeadImg(userId, 5);
    }

    private List<UserInviteDTO> convert(Long userId, List<UserInviteHistoryBean> histories) {
        ArrayList<UserInviteDTO> result = new ArrayList<UserInviteDTO>(histories.size());
        histories.forEach(item -> result.add(UserInviteDTO.builder().activeVip(Boolean.valueOf(Objects.equals(item.getActiveVip(), (byte)1))).inviteDate(item.getCreateTime()).inviteHeadImg(item.getInviteHeadImg()).inviteNickName(item.getInviteUserNickname()).inviteUserId(item.getUserId()).relationTitle(this.getInviteProcessService().getLevelTwoFinalInviteTitle(userId, (UserInviteHistoryBean)item)).build()));
        return result;
    }

    @Override
    public UserInviteHistoryBean selectByUserId(Long userId) {
        UserInviteHistoryBean bean = this.userInviteHistoryMapper.selectByUserId(userId);
        return null == bean ? new UserInviteHistoryBean() : bean;
    }

    private void addInviteNum(UserInviteHistoryBean bean) {
        if (null == bean.getUserId() || null == bean.getInviteUserId()) {
            return;
        }
        if (null != bean.getInviteUserId()) {
            this.userAttributeService.addInviteNum(bean.getInviteUserId());
        }
        if (null != bean.getInviteSuperUserId()) {
            this.userAttributeService.addInviteNum(bean.getInviteSuperUserId());
        }
        if (null != bean.getInviteCreatedUserId() && !bean.getInviteCreatedUserId().equals(bean.getCreatedUserId()) && !bean.getInviteCreatedUserId().equals(bean.getInviteSuperUserId())) {
            this.userAttributeService.addInviteNum(bean.getInviteCreatedUserId());
        }
        if (!(null == bean.getCreatedUserId() || bean.getCreatedUserId().equals(bean.getInviteUserId()) || bean.getCreatedUserId().equals(bean.getInviteSuperUserId()) || bean.getCreatedUserId().equals(bean.getInviteCreatedUserId()))) {
            this.userAttributeService.addInviteNum(bean.getCreatedUserId());
        }
    }

    @Override
    public boolean insertOrUpdateUserInviteNotActive(Long userId, Long inviteUserId) {
        UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
        userInviteBindDTO.setIsCallback(Boolean.valueOf(false));
        userInviteBindDTO.setUserId(userId);
        userInviteBindDTO.setInviteUserId(inviteUserId);
        userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.WELFARE_VIP);
        return true;
    }

    @Override
    public Boolean insertOrUpdate(UserInviteBindDTO userInviteBindDTO) {
        if (!userInviteBindDTO.getAlreadyHas().booleanValue()) {
            log.info("\u65b0\u589e\u9080\u8bf7\u5173\u5efa\u7acb[{}]", (Object)JSONObject.toJSONString((Object)userInviteBindDTO.getUserInviteHistoryBean()));
            if (null == userInviteBindDTO.getUserInviteHistoryBean().getId()) {
                userInviteBindDTO.getUserInviteHistoryBean().setId(SequenceHolder.nextLongId());
            }
            if (Objects.equals(userInviteBindDTO.getUserInviteHistoryBean().getState(), (byte)1)) {
                userInviteBindDTO.getUserInviteHistoryBean().setBindTime(new Date());
            }
            this.addInviteNum(userInviteBindDTO.getUserInviteHistoryBean());
            return this.userInviteHistoryMapper.insert(userInviteBindDTO.getUserInviteHistoryBean()) > 0;
        }
        if (!userInviteBindDTO.getNeedUpdate().booleanValue()) {
            return false;
        }
        log.info("\u4fee\u6539\u9080\u8bf7\u5173\u7cfb[{}]", (Object)JSONObject.toJSONString((Object)userInviteBindDTO));
        this.userInviteHistoryMapper.updateInviteSelective(userInviteBindDTO.getUserInviteHistoryBean());
        return true;
    }

    @Override
    public List<UserInviteOrderVO> getUserInviteOrderTen(Integer num, String locationCode, List<Long> userIds) {
        if (null == num || num > 10) {
            num = 10;
        }
        List list = this.userInviteHistoryMapper.getInviteOrderTen(num, locationCode, userIds);
        for (UserInviteOrderVO entity : list) {
            if (!StringUtils.isEmpty((CharSequence)entity.getHeadImg())) continue;
            entity.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
        }
        return list;
    }

    @Override
    public List<UserInviteHistoryBean> getListByUid(Long userId) {
        return this.userInviteHistoryMapper.queryListAllByUid(userId);
    }

    @Override
    public InviteCounterDTO getInviteCounter(UserInviteConterParam param) {
        InviteCounterDTO inviteCounterDTO = new InviteCounterDTO();
        UserInfoDTO userCache = this.getUserService().getUserCache(param.getUserId());
        Long inviteNum = userCache.getInviteNum() == null ? Long.valueOf(0L) : Long.valueOf(userCache.getInviteNum().intValue());
        inviteCounterDTO.setTotal(inviteNum);
        inviteCounterDTO.setScollNotes(this.getScrollNotes(param.getAreaCode()));
        return inviteCounterDTO;
    }

    private List<String> getScrollNotes(String areaCode) {
        ArrayList scrollMessages = Lists.newArrayList();
        int queryNum = this.userProperties.getInviteScrollList().size();
        if (queryNum == 0) {
            return scrollMessages;
        }
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(areaCode);
        List<UserInfoDTO> virtualUsers = this.virtualUserService.listVirtualUser(queryNum);
        int index = 0;
        for (String message : this.userProperties.getInviteScrollList()) {
            UserInfoDTO virtualUser = virtualUsers.get(index);
            String scrollMsg = StringUtils.replace((String)message, (String)"{areaName}", (String)locationDTO.getName());
            scrollMsg = StringUtils.replace((String)scrollMsg, (String)"{userName}", (String)virtualUser.getNickname());
            scrollMessages.add(scrollMsg);
            ++index;
        }
        return scrollMessages;
    }

    @Override
    public void changeHistoryStatus(Long userId, Byte state) {
        UserInviteHistoryBean userInviteHistoryBean = this.userInviteHistoryMapper.selectByUserId(userId);
        if (userInviteHistoryBean != null) {
            if (!Objects.equals(userInviteHistoryBean.getState(), state)) {
                log.warn("\u7528\u6237\u9080\u8bf7\u72b6\u6001\u5f02\u5e38\uff0c\u7ecf\u8fc7\u7ed1\u5b9a\u903b\u8f91\u540e\u4ecd\u9519\u8bef\uff0c\u7528\u6237ID\uff1a{}", (Object)userId);
            }
            UserInviteHistoryBean modifyBean = new UserInviteHistoryBean();
            modifyBean.setUserId(userInviteHistoryBean.getUserId());
            modifyBean.setState(state);
            this.userInviteHistoryMapper.updateInviteSelective(modifyBean);
        }
    }

    @Override
    public UserInviteOrderVO getInviteNumByUserId(Long userId) {
        Tuple tuple = this.userInviteHistoryMapper.getCollectAll(userId);
        if (null != tuple) {
            return UserInviteOrderVO.builder().userId(userId).inviteNum(Integer.valueOf(tuple.getTotal())).build();
        }
        return UserInviteOrderVO.builder().userId(userId).inviteNum(Integer.valueOf(0)).build();
    }
}

