/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.user.auth.UserAuthCodeService;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.exception.UserRepeatCreateException;
import com.bxm.egg.user.integration.SmsIntegrationService;
import com.bxm.egg.user.invite.InviteProcessService;
import com.bxm.egg.user.login.LoginService;
import com.bxm.egg.user.login.UserAuthService;
import com.bxm.egg.user.login.UserLoginHistoryService;
import com.bxm.egg.user.login.UserParamCheckService;
import com.bxm.egg.user.login.UserService;
import com.bxm.egg.user.mapper.UserAuthMapper;
import com.bxm.egg.user.mapper.UserMapper;
import com.bxm.egg.user.model.dto.UserInfoDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmLevelInfoDTO;
import com.bxm.egg.user.model.param.InviteProcessParam;
import com.bxm.egg.user.model.vo.LoginInfo;
import com.bxm.egg.user.model.vo.LoginMeta;
import com.bxm.egg.user.model.vo.User;
import com.bxm.egg.user.model.vo.UserAuth;
import com.bxm.egg.user.param.UserWarmActionParam;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.egg.user.warmlevel.impl.WarmHandlerProxy;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="loginService")
@RefreshScope
public class LoginServiceImpl
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    private final SmsIntegrationService smsIntegrationService;
    private final UserAuthMapper userAuthMapper;
    private final UserMapper userMapper;
    private final UserService userService;
    private final RedisStringAdapter redisStringAdapter;
    private final UserAuthService userAuthService;
    private final UserLoginHistoryService userLoginHistoryService;
    private final UserParamCheckService userParamCheckService;
    private final UserAuthCodeService userAuthCodeService;
    private final InviteProcessService inviteProcessService;
    private final UserWarmLevelService userWarmLevelService;
    private final WarmHandlerProxy warmHandlerProxy;

    @Override
    @Retryable(value={RetryException.class}, backoff=@Backoff(value=300L))
    public Message doLogin(LoginInfo loginInfo, BasicParam basicParam) {
        Message message;
        UserAuth userAuth = this.userAuthMapper.selectByUserAuth(loginInfo.getType(), loginInfo.getLoginName());
        try {
            message = this.preJudgeBeforeLogin(loginInfo, basicParam, userAuth);
        }
        catch (UserRepeatCreateException e) {
            log.warn("\u91cd\u590d\u521b\u5efa\u7528\u6237\uff0c\u8fdb\u884c\u91cd\u8bd5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)loginInfo);
            throw new RetryException("\u7528\u6237\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u521b\u5efa");
        }
        if (!message.isSuccess()) {
            return message;
        }
        Boolean isReturn = (Boolean)message.getParam("return");
        if (null != isReturn && isReturn.booleanValue()) {
            return message;
        }
        LoginMeta meta = this.login(userAuth, loginInfo, basicParam);
        if (meta.getUser() != null) {
            UserWarmActionParam userWarmActionParam = UserWarmActionParam.builder().userId(meta.getUser().getId()).warmRuleEnum(WarmRuleEnum.LOGIN).build();
            this.warmHandlerProxy.handle(userWarmActionParam);
        }
        return Message.build((boolean)true).addParam("meta", (Object)meta);
    }

    private Message preJudgeBeforeLogin(LoginInfo loginInfo, BasicParam basicParam, UserAuth userAuth) throws UserRepeatCreateException {
        boolean isPublishState = false;
        if (1 != loginInfo.getType()) {
            if (null == userAuth) {
                if (!isPublishState) {
                    Message meta = this.registerByWechat(loginInfo, basicParam);
                    return meta.addParam("return", (Object)true);
                }
                LoginMeta meta = new LoginMeta();
                meta.setCode(512);
                return Message.build((boolean)true).addParam("meta", (Object)meta).addParam("return", (Object)true);
            }
        } else if (1 == loginInfo.getType()) {
            Message message;
            if (!this.userParamCheckService.checkParam(loginInfo)) {
                log.info("doLogin failed:" + loginInfo);
                return Message.build((boolean)false, (String)"\u53c2\u6570\u9519\u8bef");
            }
            if (isPublishState && this.userParamCheckService.checkVerifyPwd(loginInfo) && !(message = this.userParamCheckService.verifyPwd(loginInfo.getPassword(), userAuth)).isSuccess()) {
                return message;
            }
        }
        return Message.build((boolean)true);
    }

    private Message registerByWechat(LoginInfo loginInfo, BasicParam basicParam) throws UserRepeatCreateException {
        User user = this.getUserByType(loginInfo);
        Message messageByCheckUser = this.userParamCheckService.checkRepeatBind(user, loginInfo);
        if (!messageByCheckUser.isSuccess()) {
            return messageByCheckUser;
        }
        LoginMeta meta = this.createAndBinding(user, loginInfo, basicParam);
        return Message.build((boolean)true).addParam("meta", (Object)meta);
    }

    private LoginMeta login(UserAuth userAuth, LoginInfo loginInfo, BasicParam basicParam) {
        Message deviceExistMessage = this.userLoginHistoryService.isDeviceExist(userAuth.getUserId(), String.valueOf(basicParam.getDevcId()));
        String equipment = deviceExistMessage.getParamMap().get("equipment") == null ? null : deviceExistMessage.getParamMap().get("equipment").toString();
        User user = this.userMapper.selectByPrimaryKey(userAuth.getUserId());
        this.addWechatLoginInfo(loginInfo, user);
        UserInfoDTO dto = this.activeAndLogin(loginInfo, user, basicParam, equipment);
        if (!deviceExistMessage.isSuccess()) {
            this.saveNewUserCache(userAuth.getUserId());
        }
        this.addUserLevelInfo(user, dto);
        LoginMeta meta = new LoginMeta(dto, !deviceExistMessage.isSuccess());
        this.userLoginHistoryService.save(equipment, basicParam, user.getId(), loginInfo.getRegIp());
        return meta;
    }

    private void addUserLevelInfo(User user, UserInfoDTO userInfoDTO) {
        UserWarmLevelInfoDTO userWarmInfoCache = this.userWarmLevelService.getUserWarmInfoCache(user.getId());
        userInfoDTO.setEquityDTO(userWarmInfoCache.getEquityDTO());
    }

    private String generateToken(Long userId, String token) {
        if (null == token) {
            // empty if block
        }
        return token;
    }

    private UserInfoDTO activeAndLogin(LoginInfo loginInfo, User user, BasicParam basicParam, String equipment) {
        if (log.isDebugEnabled()) {
            log.debug("\u767b\u5f55->\u5f00\u59cb\u66f4\u65b0\u7528\u6237\u6570\u636e\uff0c\u53c2\u6570\uff1auser:[{}],\u8bbe\u5907\u53f7\uff1a[{}]", JSONObject.toJSON((Object)user), (Object)equipment);
        }
        user.setToken(this.generateToken(user.getId(), null));
        user.setEquipment(equipment);
        user.setLastLoginIp(loginInfo.getLastLoginIp());
        user.setLastLoginTime(new Date());
        user.setRegisterClient(basicParam.getPlatform() + "");
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237[{}]\u5bf9\u5e94\u7684\u72b6\u6001\uff1a[{}]", (Object)user.getId(), (Object)user.getState());
        }
        if (Objects.equals(user.getChannelId(), 0L)) {
            log.info("\u7528\u6237\u7684\u6ce8\u518c\u6e20\u9053\u672a\u5b9a\u4e49\uff0c\u7528\u6237ID:[{}],\u539f\u59cb\u6e20\u9053\uff1a[{}]", (Object)user.getId(), (Object)basicParam.getChnl());
        }
        this.updateUserActive(user, basicParam, equipment, loginInfo.getLastLoginIp());
        this.userMapper.updateByPrimaryKeySelective(user);
        UserInfoDTO userInfoDetail = this.userService.loadUserToRedis(user.getId());
        this.addAuthInfo(userInfoDetail);
        return userInfoDetail;
    }

    @Override
    public void updateUserActive(User user, BasicParam basicParam, String equipment, String loginIp) {
        if (2 == user.getState()) {
            user.setState(Byte.valueOf((byte)1));
            user.setRegisterTime(new Date());
            InviteProcessParam param = new InviteProcessParam();
            param.setInviteUserId(user.getInviteUserId());
            param.setUserId(user.getId());
            param.setBasicParam(basicParam);
            param.setEquipmentNum(equipment);
            param.setLoginIp(loginIp);
            this.inviteProcessService.execAsyncActiveInvite(param);
        }
    }

    private void addAuthInfo(UserInfoDTO userInfo) {
        userInfo.setCombineAuthCode(this.userAuthCodeService.getAuthCombineCode(userInfo.getId()));
        userInfo.setAuthResources(this.userAuthCodeService.getAuthResources(userInfo.getId()));
    }

    private void addWechatLoginInfo(LoginInfo loginInfo, User user) {
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u767b\u9646\u4f20\u5165\u7684\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)loginInfo));
        }
        if (3 == loginInfo.getType()) {
            loginInfo.setUnionId(loginInfo.getLoginName());
        }
        if (null != loginInfo.getOpenId() && null != loginInfo.getUnionId()) {
            boolean isBindMsg;
            List userAuthList = this.userAuthMapper.listByUserId(user.getId());
            if (!CollectionUtils.isEmpty((Collection)userAuthList)) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaunionId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], unionId:[{}]", (Object)user.getId(), (Object)loginInfo.getUnionId());
                }
                if (!(isBindMsg = userAuthList.stream().anyMatch(e -> e.getIdentifier().equals(loginInfo.getUnionId())))) {
                    user.setWeixin(loginInfo.getUnionId());
                    this.userAuthService.addUserAuth((byte)3, user.getId(), loginInfo.getUnionId(), null);
                }
            }
            if (!(isBindMsg = userAuthList.stream().anyMatch(e -> e.getIdentifier().equals(loginInfo.getOpenId())))) {
                log.debug("\u5f53\u524d\u7528\u6237\u521b\u5efaAPP\u5fae\u4fe1\u6388\u6743\u767b\u9646openId\u9274\u6743\u4fe1\u606f:\u7528\u6237id\uff1a[{}], openId:[{}]", (Object)user.getId(), (Object)loginInfo.getOpenId());
                this.userAuthService.addUserAuth((byte)6, user.getId(), loginInfo.getOpenId(), null);
            }
        }
    }

    private void updateUserInviteHistory() {
    }

    @Override
    @Retryable(value={RetryException.class}, backoff=@Backoff(value=300L))
    public ResponseJson<LoginMeta> registerAndBindingPhone(LoginInfo loginInfo, Long userId, BasicParam basicParam) {
        LoginMeta meta;
        if (!this.userParamCheckService.bindingAndRegisterCheckParam(loginInfo)) {
            return ResponseJson.badReqeuset((String)"\u53c2\u6570\u9519\u8bef").build();
        }
        Message messageByCheckAuth = this.userAuthService.checkBindExist(loginInfo.getType(), loginInfo.getLoginName());
        if (!messageByCheckAuth.isSuccess()) {
            return ResponseJson.badReqeuset((String)messageByCheckAuth.getLastMessage()).build();
        }
        User user = this.getUserByType(loginInfo);
        Message messageByCheckUser = this.userParamCheckService.checkRepeatBind(user, loginInfo);
        if (!messageByCheckUser.isSuccess()) {
            return ResponseJson.badReqeuset((String)messageByCheckUser.getLastMessage()).build();
        }
        if (null != userId && null != (user = this.userMapper.selectByPrimaryKey(userId)) && 0 == user.getState()) {
            user = null;
        }
        if (1 == loginInfo.getType() && StringUtils.isNotBlank((CharSequence)loginInfo.getCode()) && !this.smsIntegrationService.verifyByType(Byte.valueOf((byte)2), loginInfo.getPhone(), loginInfo.getCode()).booleanValue()) {
            return ResponseJson.badReqeuset((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9a8c\u8bc1\u7801").build();
        }
        try {
            meta = this.createAndBinding(user, loginInfo, basicParam);
        }
        catch (UserRepeatCreateException e) {
            log.warn("\u91cd\u590d\u521b\u5efa\u7528\u6237\uff0c\u8fdb\u884c\u91cd\u8bd5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)loginInfo);
            throw new RetryException("\u7528\u6237\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u521b\u5efa");
        }
        return ResponseJson.ok((Object)meta);
    }

    private User getUserByType(LoginInfo loginInfo) {
        User user = null;
        if (3 == loginInfo.getType()) {
            user = this.userMapper.findByWeixin(loginInfo.getLoginName());
        } else if (1 == loginInfo.getType()) {
            user = this.userMapper.findByPhone(loginInfo.getPhone());
        }
        return user;
    }

    private LoginMeta createAndBinding(User user, LoginInfo loginInfo, BasicParam basicParam) throws UserRepeatCreateException {
        Message deviceExistMessage;
        LoginMeta meta = new LoginMeta();
        if (null == user) {
            user = null;
            this.generateToken(user.getId(), user.getToken());
        } else {
            this.syncThirdPartyInfo(user, loginInfo);
            this.changeToken(user, loginInfo, basicParam);
            this.addUserAuth(loginInfo, user.getId());
        }
        UserInfoDTO dto = this.userService.convertUserToDTO(user);
        boolean isFirstLogin = false;
        String equipment = String.valueOf(basicParam.getDevcId());
        if (!NumberUtils.isDigits((String)String.valueOf(basicParam.getDevcId()))) {
            Object equipmentDTO = null;
            String string = equipment = equipmentDTO == null ? null : equipmentDTO.getId();
        }
        if (!(deviceExistMessage = this.userLoginHistoryService.isDeviceExistByDeviceId(user.getId(), equipment)).isSuccess()) {
            isFirstLogin = true;
        }
        if (isFirstLogin) {
            this.saveNewUserCache(user.getId());
        }
        this.addAuthInfo(dto);
        meta.setUser(dto);
        meta.setFirstLogin(isFirstLogin);
        this.userLoginHistoryService.save(equipment, basicParam, user.getId(), loginInfo.getRegIp());
        this.warmHandlerProxy.handle(UserWarmActionParam.builder().userId(user.getId()).warmRuleEnum(WarmRuleEnum.REGISTER).build());
        this.warmHandlerProxy.handle(UserWarmActionParam.builder().userId(user.getId()).warmRuleEnum(WarmRuleEnum.LOGIN).build());
        this.userService.putUserToRedis(user);
        return meta;
    }

    private void saveNewUserCache(Long id) {
        KeyGenerator key = RedisConfig.NEW_USER_LOGIN.copy().appendKey((Object)id);
        this.redisStringAdapter.set(key, (Object)true);
        this.redisStringAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private void changeToken(User user, LoginInfo loginInfo, BasicParam basicParam) {
        user.setToken(this.generateToken(user.getId(), null));
        if (loginInfo.getSex() != null) {
            user.setSex(loginInfo.getSex());
        }
        user.setLastLoginTime(new Date());
        this.userMapper.updateByPrimaryKeySelective(user);
    }

    private void firstLogin(Long userId, String wechat, Integer platform) {
    }

    private void addUserAuth(LoginInfo loginInfo, Long userId) {
        log.info("\u6dfb\u52a0\u7528\u6237\u6743\u9650\u8ba4\u8bc1");
        UserAuth auth = new UserAuth();
        auth.setUserId(userId);
        auth.setType(loginInfo.getType());
        if (StringUtils.equals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getPhone());
            if (StringUtils.isNotEmpty((CharSequence)loginInfo.getPassword())) {
                auth.setCredential(MD5Util.encode((String)loginInfo.getPassword()));
            }
            this.userAuthMapper.insertSelective(auth);
        }
        if (StringUtils.notEquals((CharSequence)loginInfo.getPhone(), (CharSequence)loginInfo.getLoginName())) {
            auth.setIdentifier(loginInfo.getLoginName());
            this.userAuthMapper.insertSelective(auth);
        }
    }

    private void syncThirdPartyInfo(User user, LoginInfo loginInfo) {
        if (1 == loginInfo.getType()) {
            user.setPhone(loginInfo.getLoginName());
        } else if (2 == loginInfo.getType()) {
            user.setQq(loginInfo.getLoginName());
        } else if (4 == loginInfo.getType()) {
            user.setWeibo(loginInfo.getLoginName());
        } else if (3 == loginInfo.getType()) {
            user.setWeixin(loginInfo.getLoginName());
            if (null != loginInfo.getNickname()) {
                user.setNickname(user.getNickname() == null ? loginInfo.getNickname() : user.getNickname());
            }
            if (null != loginInfo.getHeadImg()) {
                user.setHeadImg(user.getHeadImg() == null ? loginInfo.getHeadImg() : user.getHeadImg());
            }
        }
    }

    @Autowired
    public LoginServiceImpl(SmsIntegrationService smsIntegrationService, UserAuthMapper userAuthMapper, UserMapper userMapper, UserService userService, RedisStringAdapter redisStringAdapter, UserAuthService userAuthService, UserLoginHistoryService userLoginHistoryService, UserParamCheckService userParamCheckService, UserAuthCodeService userAuthCodeService, InviteProcessService inviteProcessService, UserWarmLevelService userWarmLevelService, WarmHandlerProxy warmHandlerProxy) {
        this.smsIntegrationService = smsIntegrationService;
        this.userAuthMapper = userAuthMapper;
        this.userMapper = userMapper;
        this.userService = userService;
        this.redisStringAdapter = redisStringAdapter;
        this.userAuthService = userAuthService;
        this.userLoginHistoryService = userLoginHistoryService;
        this.userParamCheckService = userParamCheckService;
        this.userAuthCodeService = userAuthCodeService;
        this.inviteProcessService = inviteProcessService;
        this.userWarmLevelService = userWarmLevelService;
        this.warmHandlerProxy = warmHandlerProxy;
    }
}

