/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.impl;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.SmsIntegrationService;
import com.bxm.egg.user.login.UserLoginService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.dto.token.TokenInfoDTO;
import com.bxm.egg.user.model.param.login.LoginParam;
import com.bxm.egg.user.model.param.login.LogoutParam;
import com.bxm.egg.user.model.param.login.UserSettingsPasswordParam;
import com.bxm.egg.user.token.TokenService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.param.BasicParam;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserLoginServiceImpl
implements UserLoginService {
    private static final Logger log = LoggerFactory.getLogger(UserLoginServiceImpl.class);
    private Map<UserLoginTypeEnum, AbstractUserLoginStrategy> loginStrategyMap;
    private final TokenService tokenService;
    private final UserInfoService userInfoService;
    private final SmsIntegrationService smsIntegrationService;

    public UserLoginServiceImpl(List<AbstractUserLoginStrategy> loginStrategys, TokenService tokenService, UserInfoService userInfoService, SmsIntegrationService smsIntegrationService) {
        this.tokenService = tokenService;
        this.userInfoService = userInfoService;
        this.smsIntegrationService = smsIntegrationService;
        this.loginStrategyMap = Maps.newHashMap();
        for (AbstractUserLoginStrategy loginStrategy : loginStrategys) {
            this.loginStrategyMap.put(loginStrategy.type(), loginStrategy);
        }
    }

    @Override
    public <T extends LoginParam> Message excLogin(T loginParam, UserLoginTypeEnum loginType) {
        Message message = this.loginStrategyMap.get((Object)loginType).doLogin(loginParam);
        if (!message.isSuccess()) {
            return message;
        }
        LoginResultDTO loginResultDTO = (LoginResultDTO)message.getParam("loginResultDTO");
        if (loginResultDTO == null) {
            return Message.build((boolean)false, (String)"\u8d26\u6237\u5b58\u5728\u5f02\u5e38\uff0c\u65e0\u6cd5\u767b\u5f55");
        }
        TokenInfoDTO tokenInfoDTO = this.tokenService.create(loginResultDTO.getUserId(), (BasicParam)loginParam);
        loginResultDTO.setAccessToken(tokenInfoDTO.getAccessToken());
        loginResultDTO.setRefreshToken(tokenInfoDTO.getRefreshToken());
        Message resultMsg = Message.build((boolean)true);
        resultMsg.addParam("loginResultDTO", (Object)loginResultDTO);
        return resultMsg;
    }

    @Override
    public void exitLogin(LogoutParam logoutParam) {
    }

    @Override
    public Message settingsPassword(UserSettingsPasswordParam userSettingsPasswordParam) {
        if (!this.smsIntegrationService.verifyByType(Byte.valueOf((byte)4), userSettingsPasswordParam.getPhone(), userSettingsPasswordParam.getSmsCode()).booleanValue()) {
            return Message.build((boolean)false, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.userInfoService.updateUserPassword(userSettingsPasswordParam.getUserId(), userSettingsPasswordParam.getPassword());
        return Message.build((boolean)true);
    }
}

