/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.common.constant.InfoCombineStateEnum;
import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.enums.InviteBindMethodEnum;
import com.bxm.egg.user.enums.LevelEnum;
import com.bxm.egg.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.integration.LocationIntegrationService;
import com.bxm.egg.user.invite.InviteRecordService;
import com.bxm.egg.user.invite.UserInviteService;
import com.bxm.egg.user.invite.bind.BindInviteManager;
import com.bxm.egg.user.login.UserAuthService;
import com.bxm.egg.user.login.UserLoginHistoryService;
import com.bxm.egg.user.login.UserService;
import com.bxm.egg.user.login.protocal.ProtocalProcesser;
import com.bxm.egg.user.mapper.UserAuthMapper;
import com.bxm.egg.user.mapper.UserMapper;
import com.bxm.egg.user.medal.msg.sender.UserMedalCounterSenderService;
import com.bxm.egg.user.model.dto.LocationUserInfoDTO;
import com.bxm.egg.user.model.dto.UserInfoDTO;
import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.egg.user.model.dto.UserLocationInfoDTO;
import com.bxm.egg.user.model.dto.UserTbkInfo;
import com.bxm.egg.user.model.dto.UserTbkInfoBean;
import com.bxm.egg.user.model.dto.WxUserInfo;
import com.bxm.egg.user.model.param.RiskParam;
import com.bxm.egg.user.model.param.TempUserParam;
import com.bxm.egg.user.model.param.UserBindPhoneParam;
import com.bxm.egg.user.model.vo.User;
import com.bxm.egg.user.model.vo.UserAuth;
import com.bxm.egg.user.model.vo.UserBindPhoneVO;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.egg.user.param.RecordWechatParam;
import com.bxm.egg.user.param.UserWarmActionParam;
import com.bxm.egg.user.properties.HomePageConfigProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.support.ExtendedService;
import com.bxm.egg.user.support.impl.RiskRecordServiceImpl;
import com.bxm.egg.user.warmlevel.impl.WarmHandlerProxy;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="userService")
@RefreshScope
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Resource
    private UserAuthService userAuthService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private UserProperties userProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private InviteRecordService inviteRecordService;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private UserInviteService userInviteService;
    @Resource
    private HomePageConfigProperties homePageConfigProperties;
    @Resource
    private ExtendedService extendedService;
    @Resource
    private RiskRecordServiceImpl riskRecordService;
    @Autowired
    private ProtocalProcesser protocalProcesser;
    @Autowired
    private BindInviteManager bindInviteManager;
    @Autowired
    private UserLoginHistoryService userLoginHistoryService;
    @Autowired
    private WarmHandlerProxy warmHandlerProxy;
    @Autowired
    private UserMedalCounterSenderService userMedalCounterSenderService;

    private KeyGenerator buildUserCacheKey(Long userId) {
        return RedisConfig.USER_CACHE_INFO.copy().appendKey((Object)userId);
    }

    @Override
    public int createUser(User user, BasicParam basicParam) {
        if (Objects.isNull(user.getJudgeMarker())) {
            user.setJudgeMarker(Long.valueOf(0L));
        }
        user.setJudgeMarker(Long.valueOf(BitOperatorUtil.setBitToLong((Long)user.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.VER_3_5_0.getIndex())));
        user.setJudgeMarker(Long.valueOf(BitOperatorUtil.setBitToLong((Long)user.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.VER_3_6_0.getIndex())));
        user.setJudgeMarker(Long.valueOf(BitOperatorUtil.setBitToLong((Long)user.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.VER_3_7_0.getIndex())));
        user.setJudgeMarker(Long.valueOf(BitOperatorUtil.setBitToLong((Long)user.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.VER_3_9_0.getIndex())));
        user.setJudgeMarker(Long.valueOf(BitOperatorUtil.setBitToLong((Long)user.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.VER_3_11_0.getIndex())));
        return this.userMapper.insertSelective(user);
    }

    @Override
    public UserInfoDTO getUserCache(Long userId) {
        UserInfoDTO userDTO = (UserInfoDTO)this.redisStringAdapter.get(this.buildUserCacheKey(userId), UserInfoDTO.class);
        if (null == userDTO) {
            userDTO = this.loadUserToRedis(userId);
        } else if (4 > userDTO.getV()) {
            if (log.isDebugEnabled()) {
                log.debug("\u7f13\u5b58\u5bf9\u8c61\u662f\u5386\u53f2\u7248\u672c\uff0c\u52a0\u8f7d\u65b0\u7684\u7528\u6237\u7f13\u5b58\uff0c\u7528\u6237ID\uff1a{},\u7f13\u5b58\u4e2d\u7684\u7248\u672c:{},\u5f53\u524d\u7248\u672c:{}", new Object[]{userId, userDTO.getV(), 4});
            }
            userDTO = this.loadUserToRedis(userId);
        }
        return userDTO;
    }

    @Override
    public void removeUserCache(Long userId) {
        this.redisStringAdapter.remove(this.buildUserCacheKey(userId));
    }

    @Override
    public UserInfoDTO loadUserToRedis(Long userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (null == user) {
            UserInfoDTO emptyUser = new UserInfoDTO();
            emptyUser.setId(userId);
            this.redisStringAdapter.set(this.buildUserCacheKey(userId), (Object)emptyUser, 3600L);
            return emptyUser;
        }
        return this.putUserToRedis(user);
    }

    @Override
    public UserInfoDTO putUserToRedis(User user) {
        LocationDTO locationByGeocode;
        log.debug("\u66f4\u65b0\u7528\u6237\u7f13\u5b58\uff1a[{}]", JSONObject.toJSON((Object)user));
        UserInfoDTO dto = this.convertUserToDTO(user);
        dto.setIndustry(this.getIndustryInfo(user));
        if (StringUtils.isNotEmpty((CharSequence)user.getPersonalProfile())) {
            dto.setIsDefaultPersonalProfile(Boolean.FALSE);
        } else {
            dto.setIsDefaultPersonalProfile(Boolean.TRUE);
            dto.setPersonalProfile(this.homePageConfigProperties.getDefaultPersonalProfile());
        }
        if (null != user.getHometownCode() && null != (locationByGeocode = this.locationIntegrationService.getLocationByGeocode(user.getHometownCode()))) {
            dto.setHometownName(locationByGeocode.getFullName());
        }
        if (null != user.getLocationCode() && null != (locationByGeocode = this.locationIntegrationService.getLocationByGeocode(user.getLocationCode()))) {
            dto.setLocationName(locationByGeocode.getFullName());
        }
        this.redisStringAdapter.set(this.buildUserCacheKey(user.getId()), (Object)dto);
        return dto;
    }

    private String getIndustryInfo(User user) {
        StringBuilder industryBuilder = new StringBuilder();
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getJobTitle()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getCompany())) {
            industryBuilder.append(user.getCompany()).append(user.getJobTitle());
        }
        if (StringUtils.isBlank((CharSequence)user.getJobTitle()) && StringUtils.isBlank((CharSequence)user.getCompany()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getJobCategoryName())) {
            industryBuilder.append(user.getJobCategoryName());
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getJobTitle()) && StringUtils.isBlank((CharSequence)user.getCompany()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getJobCategoryName())) {
            industryBuilder.append(user.getJobTitle());
        }
        if (StringUtils.isBlank((CharSequence)user.getJobTitle()) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)user.getCompany())) {
            industryBuilder.append(user.getCompany());
        }
        if (industryBuilder.length() > 0) {
            return industryBuilder.toString();
        }
        return null;
    }

    @Override
    public boolean checkUserExistByPhone(String phone) {
        return Objects.nonNull(this.userMapper.findByPhone(phone));
    }

    @Override
    public UserInfoDTO convertUserToDTO(User user) {
        UserInfoDTO dto = new UserInfoDTO();
        BeanUtils.copyProperties((Object)user, (Object)dto);
        if (StringUtils.isBlank((CharSequence)dto.getNickname())) {
            dto.setNickname(com.bxm.newidea.component.tools.StringUtils.hideMobile((String)user.getPhone()));
        }
        if (StringUtils.isNotBlank((CharSequence)user.getLocationName())) {
            dto.setLocationShortName(user.getLocationName());
        }
        if (StringUtils.isBlank((CharSequence)dto.getHeadImg())) {
            dto.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
        }
        dto.setIsTempNickName(Byte.valueOf((byte)1));
        return dto;
    }

    @Override
    public void checkCompleteInfo(User user) {
        long infoCompleteStatus = user.getInfoCompleteState();
        log.debug("\u7528\u6237\u5b8c\u5584\u8d44\u6599\u7a0b\u5ea6\u4fe1\u606f:[{}]", (Object)infoCompleteStatus);
        if (InfoCombineStateEnum.values().length == InfoCombineStateEnum.getInfoCompleteStatus((Long)infoCompleteStatus)) {
            UserWarmActionParam warmActionParam = UserWarmActionParam.builder().build();
            warmActionParam.setUserId(user.getId());
            warmActionParam.setWarmRuleEnum(WarmRuleEnum.FINISH_ONESELF_DATA);
            this.warmHandlerProxy.handle(warmActionParam);
            log.debug("\u7528\u6237\u5df2\u5b8c\u5584\u8d44\u6599\uff0c\u8c03\u7528\u5b8c\u6210\u8d44\u6599\u63a5\u53e3:[{}]", (Object)infoCompleteStatus);
        }
    }

    @Override
    public Message getWxUserInfo(TempUserParam tempUserParam, HttpServletRequest request) {
        Message message = this.createTempUser(tempUserParam);
        if (message.isSuccess()) {
            WxUserInfo wxUserInfo = new WxUserInfo();
            wxUserInfo.setUserId(Long.valueOf((Long)message.getParamMap().get("userId")));
            wxUserInfo.setHeadImg(tempUserParam.getHeadImg());
            wxUserInfo.setUnionId(tempUserParam.getUnionId());
            wxUserInfo.setNickname(tempUserParam.getNickName());
            log.info("\u521b\u5efa\u4e34\u65f6\u7528\u6237\u6210\u529f:[{}]", JSONObject.toJSON((Object)wxUserInfo));
            return Message.build((boolean)true).addParam("wxUserInfo", (Object)wxUserInfo);
        }
        return message;
    }

    @Override
    public LocationUserInfoDTO getLocationUserInfo(Long userId) {
        return this.userMapper.getLocationUserInfo(userId);
    }

    @Override
    public User selectByPrimaryKey(Long userId) {
        return this.userMapper.selectByPrimaryKey(userId);
    }

    @Override
    public Long addWSTAppletUser() {
        User user = this.saveWSTUser();
        return user.getId();
    }

    private User saveWSTUser() {
        User user = new User();
        user.setRegisterClient("5");
        user.setAge(0);
        user.setSex(Byte.valueOf((byte)0));
        user.setState(Byte.valueOf((byte)2));
        user.setLevel(LevelEnum.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        user.setNewbieGuideFlag(Byte.valueOf((byte)0));
        int count = this.createUser(user, null);
        if (count > 0) {
            User updateUser = new User();
            this.userMapper.updateByPrimaryKeySelective(updateUser);
            this.loadUserToRedis(user.getId());
        }
        return user;
    }

    @Override
    public Message createTempUser(TempUserParam userParam) {
        if (StringUtils.isBlank((CharSequence)userParam.getUnionId()) && null == userParam.getUserId()) {
            log.error("\u521b\u5efa\u4e34\u65f6\u7528\u6237\u51fa\u73b0\u9519\u8bef\uff0c\u53c2\u6570\u975e\u6cd5:[{}]", JSONObject.toJSON((Object)userParam));
            return Message.build((boolean)false, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        log.info("\u5f00\u59cb\u521b\u5efa\u4e34\u65f6\u7528\u6237\uff0c\u53c2\u6570:[{}]", (Object)JSON.toJSONString((Object)userParam));
        User user = new User();
        this.convertTempUser(userParam, user);
        UserAuth unionUserAuth = null;
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userParam.getUnionId())) {
            unionUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)3), userParam.getUnionId());
        }
        User existedUser = null;
        Long userId = null;
        if (null != userParam.getUserId()) {
            existedUser = this.userMapper.selectByPrimaryKey(userParam.getUserId());
        } else if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userParam.getUnionId()) && null != unionUserAuth) {
            existedUser = this.userMapper.selectByPrimaryKey(unionUserAuth.getUserId());
        }
        if (null != existedUser) {
            userId = existedUser.getId();
        }
        if (null == existedUser && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)userParam.getUnionId())) {
            log.debug("\u6839\u636e\u7528\u6237id\u6216\u8005unionId\u65e0\u6cd5\u67e5\u8be2\u5230\u7528\u6237\uff0c\u521b\u5efa\u65b0\u7528\u6237");
            if (this.distributedLock.lock(userParam.getUnionId(), 1L, TimeUnit.SECONDS)) {
                this.createUser(user, (BasicParam)userParam);
                userId = user.getId();
                this.userAuthService.addUserAuth((byte)3, userId, userParam.getUnionId(), null);
            }
        }
        this.loadUserToRedis(userId);
        this.afterProcessing(userParam, userId);
        UserInviteBindDTO inviteBindDTO = this.convertUserToInviteBind(user);
        if (null == inviteBindDTO.getUserId()) {
            inviteBindDTO.setUserId(userId);
        }
        this.bindInviteManager.bindInvite(inviteBindDTO);
        return Message.build((boolean)true).addParam("userId", (Object)userId);
    }

    private void afterProcessing(TempUserParam userParam, Long userId) {
        if (null != userParam.getOpenId()) {
            if (InviteTypeEnum.APPLETDRAW.getName().equals(userParam.getInviteType())) {
                UserAuth appletUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)7), userParam.getOpenId());
                if (null == appletUserAuth || null == appletUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)7, userId, userParam.getOpenId(), null);
                }
            } else {
                UserAuth weixinUserAuth = this.userAuthMapper.selectByUserAuth(Byte.valueOf((byte)5), userParam.getOpenId());
                if (null == weixinUserAuth || null == weixinUserAuth.getUserId()) {
                    this.userAuthService.addUserAuth((byte)5, userId, userParam.getOpenId(), null);
                }
            }
        }
    }

    private UserInviteBindDTO convertUserToInviteBind(User user) {
        UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
        userInviteBindDTO.setUser(user);
        userInviteBindDTO.setUserId(user.getId());
        userInviteBindDTO.setInviteUserId(user.getInviteUserId());
        userInviteBindDTO.setRelationId(user.getRelationId());
        userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.CREATE_TEMP_USER);
        return userInviteBindDTO;
    }

    private void updateUserAuth(UserAuth openUserAuth, Long userId) {
        if (!userId.equals(openUserAuth.getUserId())) {
            this.userAuthMapper.removeAuth(Byte.valueOf((byte)8), userId);
            this.userAuthMapper.removeAuth(Byte.valueOf((byte)8), openUserAuth.getUserId());
            openUserAuth.setId(SequenceHolder.nextLongId());
            openUserAuth.setUserId(userId);
            this.userAuthMapper.insertSelective(openUserAuth);
        }
    }

    private void addInviteRecord(TempUserParam userParam, Long userId, Boolean isInsertInviteRecord) {
        if (isInsertInviteRecord.booleanValue() && userParam.getInviteUserId() != null && !userParam.getInviteUserId().equals(userId)) {
            this.inviteRecordService.addInviteRecord(userParam.getInviteUserId(), userId, userParam.getInviteType());
            RecordWechatParam recordWechatParam = new RecordWechatParam();
            recordWechatParam.setUserId(userParam.getInviteUserId());
            recordWechatParam.setWechatUid(userParam.getUnionId());
            recordWechatParam.setWechatImg(userParam.getHeadImg());
            recordWechatParam.setWechatName(userParam.getNickName());
            log.debug("\u6dfb\u52a0VIP\u9080\u8bf7\u8bb0\u5f55: \u9080\u8bf7\u4eba\uff1a[{}], \u53d7\u9080\u4eba\uff1a[{}]", (Object)userParam.getInviteUserId(), (Object)userParam.getUnionId());
        }
    }

    private void convertTempUser(TempUserParam tempUserParam, User user) {
        UserLocationInfoDTO infoDTO;
        user.setWeixin(tempUserParam.getUnionId());
        user.setNickname(EmojiCodeParser.replaceSoftbankEmoji((String)tempUserParam.getNickName()));
        user.setHeadImg(tempUserParam.getHeadImg());
        Long userId = user.getId() == null ? SequenceHolder.nextLongId() : user.getId();
        String headImg = this.extendedService.uploadHeadImg(tempUserParam.getHeadImg(), userId);
        if (StringUtils.isNotEmpty((CharSequence)headImg)) {
            user.setHeadImg(headImg);
        }
        user.setSex(tempUserParam.getSex());
        user.setRegIp(tempUserParam.getRegIp());
        user.setRegisterClient(Objects.toString(tempUserParam.getPlatform()));
        user.setRegisteredAddress(tempUserParam.getRegisteredAddress());
        user.setLocationCode(tempUserParam.getLocationCode());
        user.setLocationName(tempUserParam.getLocationName());
        if (StringUtils.isBlank((CharSequence)tempUserParam.getLocationCode()) && Objects.nonNull(tempUserParam.getInviteUserId()) && Objects.nonNull(infoDTO = this.getUserLocationCodeById(tempUserParam.getInviteUserId()))) {
            user.setLocationCode(infoDTO.getLocationCode());
            user.setLocationName(infoDTO.getLocationShortName());
        }
        user.setRelationId(tempUserParam.getRelationId());
        user.setInviteUserId(tempUserParam.getInviteUserId());
        user.setRegisterChannel(tempUserParam.getInviteType());
        User inviteUser = this.userMapper.selectByPrimaryKey(tempUserParam.getInviteUserId());
        if (inviteUser == null) {
            log.info("\u53d7\u9080\u7528\u6237[{}]\u7684\u9080\u8bf7\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)user.getId(), (Object)tempUserParam);
            user.setInviteLevel(Integer.valueOf(1));
        } else {
            log.info("\u521b\u5efa\u9080\u8bf7\u7528\u6237[{}]\u7684\u53d7\u9080\u7528\u6237", (Object)inviteUser.getId());
            user.setInviteLevel(Integer.valueOf(inviteUser.getInviteLevel() + 1));
        }
        user.setState(Byte.valueOf((byte)2));
        user.setLevel(LevelEnum.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        user.setNewbieGuideFlag(Byte.valueOf((byte)0));
    }

    @Override
    public List<UserInfoDTO> getBatchUserInfo(Collection<Long> userIds) {
        ArrayList userInfos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.forEach(userId -> {
                UserInfoDTO userInfoDTO = this.getUserCache((Long)userId);
                if (null != userInfoDTO) {
                    userInfos.add(userInfoDTO);
                }
            });
        }
        return userInfos;
    }

    @Override
    public String getGeneration(LocalDate birthday) {
        String generationStr = null;
        if (null != birthday) {
            int year = birthday.getYear();
            int decade = year / 10;
            String s = String.valueOf(decade);
            generationStr = s.substring(s.length() - 1) + "0\u540e";
        }
        return generationStr;
    }

    private UserTbkInfo build(UserTbkInfoBean infoBean) {
        if (Objects.isNull(infoBean)) {
            return null;
        }
        UserTbkInfo info = new UserTbkInfo();
        info.setId(infoBean.getId());
        info.setNickname(infoBean.getNickname());
        info.setIsNovice(Boolean.valueOf(!BitOperatorUtil.getBitAsBoolean((Long)infoBean.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.HAS_ORDERED.getIndex())));
        info.setJudgeMarker(infoBean.getJudgeMarker());
        info.setTbkSpecialId(infoBean.getTbkSpecialId());
        info.setTbkRelationId(infoBean.getTbkRelationId());
        info.setTalentLevel(infoBean.getTalentLevel());
        UserInviteHistoryBean userInviteHistoryBean = this.userInviteService.selectByUserId(infoBean.getId());
        if (Objects.nonNull(userInviteHistoryBean)) {
            info.setSuperiorUserId(userInviteHistoryBean.getInviteUserId());
            info.setTopUserId(userInviteHistoryBean.getInviteSuperUserId());
            info.setContentSuperiorUserId(userInviteHistoryBean.getCreatedUserId());
            info.setContentTopUserId(userInviteHistoryBean.getInviteCreatedUserId());
        }
        return info;
    }

    private Boolean checkRisk(String phone, BasicParam basicParam, String deviceToken, String ip) {
        String operateSource = "";
        if (basicParam.getPlatform() == 1) {
            operateSource = "ANDROID";
        } else if (basicParam.getPlatform() == 2) {
            operateSource = "IOS";
        }
        RiskParam riskParam = new RiskParam();
        riskParam.setDeviceToken(deviceToken);
        riskParam.setIp(ip);
        riskParam.setOperateSource(operateSource);
        riskParam.setPhone(phone);
        Object equipmentDTO = null;
        if (null != equipmentDTO && com.bxm.newidea.component.tools.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{equipmentDTO.getId()})) {
            riskParam.setEquiment(equipmentDTO.getId());
            riskParam.setOperateSystem(equipmentDTO.getPhoneModel());
        }
        return this.riskRecordService.checkRiskDevice(riskParam);
    }

    @Override
    public UserBindPhoneVO checkUserAndPhoneExists(UserBindPhoneParam phoneParam) {
        UserBindPhoneVO result = new UserBindPhoneVO();
        User user = null;
        if (null == phoneParam.getUserId() && com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)phoneParam.getPhone())) {
            result.setStatus(0);
            result.setMsg("\u624b\u673a\u53f7\u548c\u7528\u6237id\u5fc5\u4f20\u4e00\u4e2a");
            return result;
        }
        if (null != phoneParam.getUserId()) {
            user = this.userMapper.selectByPrimaryKey(phoneParam.getUserId());
            if (null == user) {
                result.setStatus(6);
                result.setMsg("\u7528\u6237\u4e0d\u5b58\u5728");
                return result;
            }
            if (StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
                result.setStatus(5);
                result.setMsg("\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u624b\u673a\u53f7");
                return result;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)phoneParam.getPhone())) {
            if (!Validater.checkPhone((String)phoneParam.getPhone())) {
                result.setStatus(4);
                result.setMsg("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
                return result;
            }
            user = this.userMapper.findByPhone(phoneParam.getPhone());
            if (null != user && StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
                result.setStatus(3);
                result.setMsg("\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528");
                return result;
            }
        }
        return result;
    }

    @Override
    public UserLocationInfoDTO getUserLocationCodeById(Long userId) {
        UserInfoDTO userCache = this.getUserCache(userId);
        return Objects.isNull(userCache) ? null : this.convert(userCache);
    }

    private UserLocationInfoDTO convert(UserInfoDTO userInfoDTO) {
        UserLocationInfoDTO locationInfoDTO = new UserLocationInfoDTO();
        locationInfoDTO.setId(userInfoDTO.getId());
        locationInfoDTO.setLocationCode(userInfoDTO.getLocationCode());
        locationInfoDTO.setLocationName(userInfoDTO.getLocationName());
        locationInfoDTO.setLocationShortName(userInfoDTO.getLocationShortName());
        return locationInfoDTO;
    }
}

