/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.protocal;

import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.user.login.protocal.AbstractProtocalStrategy;
import com.bxm.egg.user.login.protocal.InviteProtocalMethod;
import com.bxm.egg.user.model.dto.ProtocalInfoStrategyDTO;
import com.bxm.egg.user.model.param.UserClipboardParam;
import com.bxm.egg.user.utils.ProtocalUtils;
import com.bxm.newidea.component.bo.Message;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProtocalProcesser {
    private static final Logger log = LoggerFactory.getLogger(ProtocalProcesser.class);
    private final Map<Integer, AbstractProtocalStrategy> map = new HashMap<Integer, AbstractProtocalStrategy>();
    private final AbstractProtocalStrategy defaultProtocal;

    @Autowired
    public ProtocalProcesser(List<AbstractProtocalStrategy> list, InviteProtocalMethod inviteProtocalMethod) {
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(abstractProtocalStrategy -> this.map.put(abstractProtocalStrategy.getType(), (AbstractProtocalStrategy)abstractProtocalStrategy));
        }
        this.defaultProtocal = inviteProtocalMethod;
    }

    public void execProtocal(UserClipboardParam userClipboardParam) {
        log.debug("\u7c98\u8d34\u677f\u4e0a\u4f20\u5185\u5bb9\uff1a{}", (Object)JSONObject.toJSONString((Object)userClipboardParam));
        if (!CollectionUtils.isEmpty((Collection)userClipboardParam.getStoreProtocals())) {
            for (int i = 0; i < userClipboardParam.getStoreProtocals().size(); ++i) {
                ProtocalInfoStrategyDTO protocalInfoStrategyDTO = new ProtocalInfoStrategyDTO();
                protocalInfoStrategyDTO.setUserClipboardParam(userClipboardParam);
                if (!this.doInit(protocalInfoStrategyDTO, (String)userClipboardParam.getStoreProtocals().get(i))) continue;
                Message message = this.map.get(protocalInfoStrategyDTO.getType()).doInvokeProtocal(protocalInfoStrategyDTO);
                log.info("\u5904\u7406\u7c98\u8d34\u677f\u5185\u5bb9\u7ed3\u679c[{}]\uff0c\u5904\u7406\u7ed3\u679c[{}]", userClipboardParam.getStoreProtocals().get(i), (Object)JSONObject.toJSONString((Object)message));
            }
        }
    }

    private boolean doInit(ProtocalInfoStrategyDTO param, String protocal) {
        if (!protocal.startsWith("wst:")) {
            return false;
        }
        Map dealWithValue = ProtocalUtils.dealWithPosters((String)protocal);
        if (null == dealWithValue) {
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)((CharSequence)dealWithValue.get("type")))) {
            return false;
        }
        param.setParams(dealWithValue);
        param.setType(Integer.valueOf(Integer.parseInt((String)dealWithValue.get("type"))));
        return true;
    }
}

